/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration.fish;

import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.util.ResourceType;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class FishIngredient {
    private static final Map<FishIngredient, WeakReference<ResourceFishEntity>> cache = new WeakHashMap<FishIngredient, WeakReference<ResourceFishEntity>>();
    public final ResourceLocation fishType;
    private final EntityType<ResourceFishEntity> entityType;

    public FishIngredient(ResourceLocation fishType, EntityType<ResourceFishEntity> entityType) {
        this.fishType = fishType;
        this.entityType = entityType;
    }

    public ResourceFishEntity getCachedEntity(Level world) {
        ResourceFishEntity entity = null;
        WeakReference<ResourceFishEntity> ref = cache.get(this);
        if (ref != null) {
            entity = (ResourceFishEntity)((Object)ref.get());
        }
        if (entity == null && world != null && (entity = (ResourceFishEntity)this.entityType.create(world)) != null) {
            entity.setResourceType(ResourceType.get(this.fishType));
            entity.setVariant(ResourceFishEntity.generateVariant(ResourceType.get(this.fishType), world.getRandom()));
            cache.put(this, new WeakReference<ResourceFishEntity>(entity));
        }
        return entity;
    }

    public ResourceLocation getFishType() {
        return this.fishType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FishIngredient)) {
            return false;
        }
        return this.fishType.equals((Object)((FishIngredient)o).fishType);
    }

    public int hashCode() {
        return this.fishType.hashCode();
    }
}

