/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration;

import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.integration.CaviarProcessorRecipeCategory;
import com.benbenlaw.resourcefish.integration.FishBreedingRecipeCategory;
import com.benbenlaw.resourcefish.integration.FishDropsRecipeCategory;
import com.benbenlaw.resourcefish.integration.FishInfusingRecipeCategory;
import com.benbenlaw.resourcefish.integration.ItemSubtypeInterpreter;
import com.benbenlaw.resourcefish.integration.fish.FishDropsRecipe;
import com.benbenlaw.resourcefish.integration.fish.FishIngredient;
import com.benbenlaw.resourcefish.integration.fish.FishIngredientHelper;
import com.benbenlaw.resourcefish.integration.fish.FishIngredientRenderer;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.CaviarProcessorRecipe;
import com.benbenlaw.resourcefish.recipe.FishBreedingRecipe;
import com.benbenlaw.resourcefish.recipe.FishInfusingRecipe;
import com.benbenlaw.resourcefish.recipe.ResourceFishRecipes;
import com.benbenlaw.resourcefish.util.ResourceType;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIResourceFishPlugin
implements IModPlugin {
    public static IDrawableStatic slotDrawable;
    public static final IIngredientType<FishIngredient> FISH_INGREDIENT_TYPE;
    public static RecipeType<FishBreedingRecipe> BREEDING_RECIPE_TYPE;
    public static RecipeType<FishInfusingRecipe> INFUSING_RECIPE_TYPE;
    public static RecipeType<FishDropsRecipe> DROPS_RECIPE_TYPE;
    public static RecipeType<CaviarProcessorRecipe> PROCESSOR_RECIPE_TYPE;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishBlocks.TANK_CONTROLLER.get()), new RecipeType[]{FishDropsRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishBlocks.TANK_CONTROLLER.get()), new RecipeType[]{FishBreedingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishItems.BREEDING_UPGRADE.get()), new RecipeType[]{FishBreedingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishBlocks.TANK_CONTROLLER.get()), new RecipeType[]{FishInfusingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishItems.INFUSING_UPGRADE.get()), new RecipeType[]{FishInfusingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ResourceFishBlocks.CAVIAR_PROCESSOR.get()), new RecipeType[]{CaviarProcessorRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FishDropsRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FishBreedingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FishInfusingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CaviarProcessorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList<FishDropsRecipe> recipes = new ArrayList<FishDropsRecipe>();
        for (ResourceType type : ResourceType.getAll()) {
            recipes.add(new FishDropsRecipe(type.getId(), type.getBiomes(), type.getDropIntervalTicks(), type.getDropItems(), new FishIngredient(type.getId(), ResourceFishEntities.RESOURCE_FISH.get())));
        }
        registration.addRecipes(FishDropsRecipeCategory.RECIPE_TYPE, recipes);
        registration.addRecipes(FishBreedingRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ResourceFishRecipes.FISH_BREEDING_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(FishInfusingRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ResourceFishRecipes.FISH_INFUSING_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(CaviarProcessorRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ResourceFishRecipes.CAVIAR_PROCESSOR_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ResourceFishItems.RESOURCE_FISH_SPAWN_EGG.asItem(), (ISubtypeInterpreter)new ItemSubtypeInterpreter());
        registration.registerSubtypeInterpreter(ResourceFishItems.CAVIAR.asItem(), (ISubtypeInterpreter)new ItemSubtypeInterpreter());
        registration.registerSubtypeInterpreter(ResourceFishItems.RESOURCE_FISH_BUCKET.asItem(), (ISubtypeInterpreter)new ItemSubtypeInterpreter());
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        ArrayList<FishIngredient> fishIngredients = new ArrayList<FishIngredient>();
        for (ResourceType type : ResourceType.getAll()) {
            fishIngredients.add(new FishIngredient(type.getId(), ResourceFishEntities.RESOURCE_FISH.get()));
        }
        registration.register(FISH_INGREDIENT_TYPE, fishIngredients, (IIngredientHelper)new FishIngredientHelper(), (IIngredientRenderer)new FishIngredientRenderer());
    }

    static {
        FISH_INGREDIENT_TYPE = () -> FishIngredient.class;
        BREEDING_RECIPE_TYPE = new RecipeType(FishBreedingRecipeCategory.UID, FishBreedingRecipe.class);
        INFUSING_RECIPE_TYPE = new RecipeType(FishInfusingRecipeCategory.UID, FishInfusingRecipe.class);
        DROPS_RECIPE_TYPE = new RecipeType(FishDropsRecipeCategory.UID, FishDropsRecipe.class);
        PROCESSOR_RECIPE_TYPE = new RecipeType(CaviarProcessorRecipeCategory.UID, CaviarProcessorRecipe.class);
    }
}

