/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.integration.JEIResourceFishPlugin;
import com.benbenlaw.resourcefish.integration.fish.FishDropsRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FishDropsRecipeCategory
implements IRecipeCategory<FishDropsRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"fish_drops");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/gui/jei_fish_drops.png");
    static final RecipeType<FishDropsRecipe> RECIPE_TYPE = RecipeType.create((String)"resourcefish", (String)"fish_drops", FishDropsRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private List<ResourceFishEntity> cachedEntity = new ArrayList<ResourceFishEntity>();

    public FishDropsRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ResourceFishBlocks.TANK_CONTROLLER.get()));
        for (int i = 0; i < 3; ++i) {
            this.cachedEntity.add(null);
        }
    }

    public RecipeType<FishDropsRecipe> getRecipeType() {
        return JEIResourceFishPlugin.DROPS_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.resourcefish.fish_drops");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FishDropsRecipe recipe, IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 7, 11).addIngredient(JEIResourceFishPlugin.FISH_INGREDIENT_TYPE, (Object)recipe.fish())).addRichTooltipCallback((iRecipeSlotView, iTooltipBuilder) -> iTooltipBuilder.add((FormattedText)Component.translatable((String)"jei.resourcefish.fish_in_tank_area").withStyle(ChatFormatting.GOLD)));
        ArrayList<ChanceResult> modifiedOutputs = new ArrayList<ChanceResult>(recipe.drops());
        int size = modifiedOutputs.size();
        int centerX = size > 0 ? 1 : 10;
        int centerY = size > 5 ? 2 : 11;
        int xOffset = 0;
        int yOffset = 0;
        int index = 0;
        for (int i = 0; i < size; ++i) {
            xOffset = centerX + i % 5 * 18;
            yOffset = centerY + i / 5 * 18;
            int finalIndex = index = i;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 49 + xOffset, yOffset).addItemStack(((ChanceResult)modifiedOutputs.get(i)).stack())).addRichTooltipCallback((slotView, tooltip) -> {
                ChanceResult output = (ChanceResult)modifiedOutputs.get(finalIndex);
                float chance = output.chance();
                tooltip.add((FormattedText)Component.translatable((String)"jei.resourcefish.chance").append(String.valueOf((int)(chance * 100.0f))).append("%").withStyle(ChatFormatting.GOLD));
            }).setBackground((IDrawable)JEIResourceFishPlugin.slotDrawable, -1, -1);
        }
    }

    public void draw(FishDropsRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)0, (int)0, (int)32, (int)12, (int)14, (int)14)) {
            guiGraphics.renderTooltip(font, (Component)Component.translatable((String)"jei.resourcefish.duration", (Object[])new Object[]{recipe.dropInterval()}), 2 + (int)mouseX, (int)mouseY - 14);
        }
    }
}

