/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration;

import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.integration.JEIResourceFishPlugin;
import com.benbenlaw.resourcefish.recipe.CaviarProcessorRecipe;
import com.benbenlaw.resourcefish.util.SizedIngredientChanceResult;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CaviarProcessorRecipeCategory
implements IRecipeCategory<CaviarProcessorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"caviar_processor");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)"textures/gui/jei_fish_drops.png");
    static final RecipeType<CaviarProcessorRecipe> RECIPE_TYPE = RecipeType.create((String)"resourcefish", (String)"caviar_processor", CaviarProcessorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridWidgetFactory;
    private List<ResourceFishEntity> cachedEntity = new ArrayList<ResourceFishEntity>();

    public CaviarProcessorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ResourceFishBlocks.CAVIAR_PROCESSOR.get()));
        for (int i = 0; i < 3; ++i) {
            this.cachedEntity.add(null);
        }
        this.scrollGridWidgetFactory = helper.createScrollGridFactory(4, 2);
        this.scrollGridWidgetFactory.setPosition(50, 0);
    }

    @Nullable
    public ResourceLocation getRegistryName(CaviarProcessorRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CaviarProcessorRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((CaviarProcessorRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public RecipeType<CaviarProcessorRecipe> getRecipeType() {
        return JEIResourceFishPlugin.PROCESSOR_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.resourcefish.caviar_processor");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CaviarProcessorRecipe recipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 11).addItemStack(recipe.caviar());
        for (SizedIngredientChanceResult result : recipe.getRollResults()) {
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridWidgetFactory).addIngredients(result.output().ingredient())).addRichTooltipCallback((slotView, tooltip) -> {
                double baseChance = result.chance();
                int asPercent = Math.round((float)(baseChance * 100.0));
                tooltip.add((FormattedText)Component.translatable((String)"jei.resourcefish.chance").append(String.valueOf(asPercent)).append("%").withStyle(ChatFormatting.GOLD));
            });
        }
        if (recipe.fluidStack() != null && !recipe.fluidStack().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridWidgetFactory).addFluidStack(recipe.fluidStack().getFluid())).addRichTooltipCallback((slotView, tooltip) -> {
                tooltip.add((FormattedText)Component.translatable((String)"jei.resourcefish.fluid_amount").append(String.valueOf(recipe.fluidStack().getAmount())).append("mB").withStyle(ChatFormatting.GOLD));
                tooltip.add((FormattedText)Component.translatable((String)"jei.resourcefish.needs_tank_upgrade").withStyle(ChatFormatting.GOLD));
            });
        }
    }

    public void draw(CaviarProcessorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
    }
}

