/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.event;

import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(modid="resourcefish", value={Dist.CLIENT})
public class TooltipEvent {
    @SubscribeEvent
    public static void onTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(ResourceFishItems.RESOURCE_FISH_SPAWN_EGG) || stack.is(ResourceFishItems.CAVIAR) || stack.is(ResourceFishItems.RESOURCE_FISH_BUCKET)) {
            return;
        }
        if (stack.has((DataComponentType)ResourceFishDataComponents.FISH_TYPE.get())) {
            ResourceLocation resourceType = (ResourceLocation)stack.get(ResourceFishDataComponents.FISH_TYPE);
            if (resourceType == null) {
                return;
            }
            CharSequence[] parts = resourceType.getPath().split("_");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].isEmpty()) continue;
                parts[i] = ((String)parts[i]).substring(0, 1).toUpperCase() + ((String)parts[i]).substring(1);
            }
            String formattedName = String.join((CharSequence)" ", parts);
            MutableComponent newTitle = Component.literal((String)(stack.getHoverName().getString() + " (" + formattedName + ")"));
            event.getTooltipElements().set(0, Either.left((Object)newTitle));
        }
    }
}

