/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data.builders;

import com.benbenlaw.resourcefish.recipe.FishBreedingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishBreedingRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected ResourceLocation parentIngredientA;
    protected ResourceLocation parentIngredientB;
    protected SizedIngredient breedingIngredient;
    protected int duration;
    protected double chance;
    protected ResourceLocation createdFish;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public FishBreedingRecipeBuilder(ResourceLocation parentIngredientA, ResourceLocation parentIngredientB, SizedIngredient breedingIngredient, int duration, double chance, ResourceLocation createdFish) {
        this.parentIngredientA = parentIngredientA;
        this.parentIngredientB = parentIngredientB;
        this.breedingIngredient = breedingIngredient;
        this.duration = duration;
        this.chance = chance;
        this.createdFish = createdFish;
    }

    public static FishBreedingRecipeBuilder createFishBreedingRecipe(ResourceLocation parentIngredientA, ResourceLocation parentIngredientB, SizedIngredient breedingIngredient, int duration, double chance, ResourceLocation createdFish) {
        return new FishBreedingRecipeBuilder(parentIngredientA, parentIngredientB, breedingIngredient, duration, chance, createdFish);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String goupName) {
        this.group = goupName;
        return this;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)("breeding/" + this.createdFish.getPath())));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        FishBreedingRecipe fishBreedingRecipe = new FishBreedingRecipe(this.parentIngredientA, this.parentIngredientB, this.breedingIngredient, this.duration, this.chance, this.createdFish);
        recipeOutput.accept(id, (Recipe)fishBreedingRecipe, builder.build(id.withPrefix("recipes/breeding/")));
    }
}

