/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data;

import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ResourceFishLangProvider
extends LanguageProvider {
    public ResourceFishLangProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "resourcefish", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.resourcefish", "Resource Fish");
        this.addJEITranslation("spawn_biome", "Spawn Biome(s):");
        this.addJEITranslation("chance", "Chance: ");
        this.addJEITranslation("fish_in_tank_area", "Fish must be in tank area!");
        this.addJEITranslation("resource_fish", "Resource Fish");
        this.addJEITranslation("duration", "Duration: %s");
        this.addJEITranslation("fluid_amount", "Amount: ");
        this.addJEITranslation("needs_tank_upgrade", "Caviar Processor needs a Tank Upgrade to produce fluids!");
        this.addItemTranslation("caviar", "Caviar");
        this.addItemTranslation("resource_fish_spawn_egg", "%s Resource Fish Spawn Egg");
        this.addItemTranslation("resource_fish_bucket", "%s Resource Fish Bucket");
        this.addItemTranslation("depth_upgrade_1", "Depth Upgrade 1");
        this.addItemTranslation("depth_upgrade_2", "Depth Upgrade 2");
        this.addItemTranslation("depth_upgrade_3", "Depth Upgrade 3");
        this.addItemTranslation("width_upgrade_1", "Width Upgrade 1");
        this.addItemTranslation("width_upgrade_2", "Width Upgrade 2");
        this.addItemTranslation("width_upgrade_3", "Width Upgrade 3");
        this.addItemTranslation("speed_upgrade_1", "Speed Upgrade 1");
        this.addItemTranslation("speed_upgrade_2", "Speed Upgrade 2");
        this.addItemTranslation("speed_upgrade_3", "Speed Upgrade 3");
        this.addItemTranslation("tank_upgrade", "Tank Upgrade");
        this.addItemTranslation("breeding_upgrade", "Breeding Upgrade");
        this.addItemTranslation("infusing_upgrade", "Infusing Upgrade");
        this.addItemTranslation("round_robin_upgrade", "Round Robin Upgrade");
        this.addItemTranslation("basic_fish_food", "Basic Fish Food");
        this.addItemTranslation("metallic_fish_food", "Metallic Fish Food");
        this.addItemTranslation("crystal_fish_food", "Crystal Fish Food");
        this.addItemTranslation("nether_fish_food", "Nether Fish Food");
        this.addItemTranslation("basic_mob_fish_food", "Basic Mob Fish Food");
        this.addItemTranslation("ender_fish_food", "Ender Fish Food");
        this.addBlockTranslation("tank_controller", "Resource Fish Tank");
        this.addBlockTranslation("caviar_processor", "Caviar Processor");
        this.addBlockTranslation("tank_controller_range", "Tank Range");
        this.addBlockTranslation("nest", "Resource Fish Nest");
        this.addRecipeTranslation("caviar_processor", "Caviar Processor");
        this.addRecipeTranslation("fish_breeding", "Fish Breeding");
        this.addRecipeTranslation("fish_infusing", "Fish Infusing");
        this.addRecipeTranslation("fish_drops", "Fish Drops");
        this.addTooltipTranslation("depth_upgrade_1", "Increases tank depth by 1 (above and below)");
        this.addTooltipTranslation("depth_upgrade_2", "Increases tank depth by 2 (above and below)");
        this.addTooltipTranslation("depth_upgrade_3", "Increases tank depth by 3 (above and below)");
        this.addTooltipTranslation("width_upgrade_1", "Increases tank width by 1 (all sides)");
        this.addTooltipTranslation("width_upgrade_2", "Increases tank width by 2 (all sides)");
        this.addTooltipTranslation("width_upgrade_3", "Increases tank width by 3 (all sides)");
        this.addTooltipTranslation("speed_upgrade_1", "Reduces time to process in the Caviar Processor by 20 ticks");
        this.addTooltipTranslation("speed_upgrade_2", "Reduces time to process in the Caviar Processor by 40 ticks");
        this.addTooltipTranslation("speed_upgrade_3", "Reduces time to process in the Caviar Processor by 60 ticks");
        this.addTooltipTranslation("tank_upgrade", "Allows the Caviar Processor to produce fluids");
        this.addTooltipTranslation("breeding_upgrade", "Allows the Tank to breed fish. When installed fish will not produce caviar");
        this.addTooltipTranslation("infusing_upgrade", "Allows the Tank to infuse fish. When installed fish will not produce caviar");
        this.addTooltipTranslation("round_robin_upgrade", "Items inserted into the Caviar Processor will be distributed evenly across all input slots");
        this.add("entity.resourcefish.resource_fish", "%s Resource Fish");
        this.add("screen.resourcefish.tank_controller.overfilled", "Tank is overfilled! Drops Disabled.");
        this.add("screen.resourcefish.tank_controller.fish_types", "Fish Types in Tank:");
    }

    private void addItemTranslation(String name, String translation) {
        this.add("item.resourcefish." + name, translation);
    }

    private void addBlockTranslation(String name, String translation) {
        this.add("block.resourcefish." + name, translation);
    }

    private void addJEITranslation(String name, String translation) {
        this.add("jei.resourcefish." + name, translation);
    }

    private void addRecipeTranslation(String name, String translation) {
        this.add("recipe.resourcefish." + name, translation);
    }

    private void addTooltipTranslation(String name, String translation) {
        this.add("tooltip.resourcefish." + name, translation);
    }
}

