/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.resourcefish.block.entity.ResourceFishBlockEntities;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.ActiveRecipeType;
import com.benbenlaw.resourcefish.recipe.CaviarProcessorRecipe;
import com.benbenlaw.resourcefish.recipe.CaviarProcessorRecipeInput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CaviarProcessorBlockEntity
extends SyncableBlockEntity {
    public final ContainerData data;
    private ActiveRecipeType activeRecipe = ActiveRecipeType.NONE;
    public int[] progress = new int[8];
    public int[] maxProgress = new int[8];
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int[] UPGRADE_SLOTS = new int[]{8, 9, 10};
    public static final int[] OUTPUTS_SLOTS = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private int roundRobinIndex = 0;
    public final FluidTank TANK = new FluidTank(8000){

        protected void onContentsChanged() {
            CaviarProcessorBlockEntity.this.setChanged();
            CaviarProcessorBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return CaviarProcessorBlockEntity.this.TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return CaviarProcessorBlockEntity.this.TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return CaviarProcessorBlockEntity.this.TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == CaviarProcessorBlockEntity.this.TANK.getFluid().getFluid() || CaviarProcessorBlockEntity.this.TANK.isEmpty()) {
                return CaviarProcessorBlockEntity.this.TANK.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == CaviarProcessorBlockEntity.this.TANK.getFluid().getFluid()) {
                return CaviarProcessorBlockEntity.this.TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (CaviarProcessorBlockEntity.this.TANK.getFluidAmount() > 0) {
                return CaviarProcessorBlockEntity.this.TANK.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };
    private final ItemStackHandler itemHandler = new ItemStackHandler(22){

        protected void onContentsChanged(int slot) {
            CaviarProcessorBlockEntity.this.setChanged();
            CaviarProcessorBlockEntity.this.sync();
            for (int upgradeSlot : UPGRADE_SLOTS) {
                if (slot != upgradeSlot) continue;
                CaviarProcessorBlockEntity.this.calculateMaxProgress();
                return;
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (Arrays.stream(INPUT_SLOTS).anyMatch(s -> s == slot) && !stack.isEmpty() && !simulate) {
                int remaining = CaviarProcessorBlockEntity.this.insertStackIntoSlots(this, stack.copy(), INPUT_SLOTS);
                if (remaining <= 0) {
                    return ItemStack.EMPTY;
                }
                return stack.copyWithCount(remaining);
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot >= 8 && slot <= 10) {
                return 1;
            }
            return 64;
        }
    };
    private final IItemHandler caviarProcessorItemHandlerSide = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (slot, stack) -> {
        for (int inputSlot : INPUT_SLOTS) {
            if (slot != inputSlot) continue;
            return true;
        }
        return false;
    }, slot -> {
        for (int outputSlot : OUTPUTS_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    });

    @NotNull
    private RecipeInput getRecipeInput() {
        return new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return CaviarProcessorBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return CaviarProcessorBlockEntity.this.itemHandler.getSlots();
            }
        };
    }

    public CaviarProcessorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ResourceFishBlockEntities.CAVIAR_PROCESSOR_BLOCK_ENTITY.get(), pos, state);
        this.calculateMaxProgress();
        this.data = new ContainerData(){

            public int get(int index) {
                if (index < 8) {
                    return CaviarProcessorBlockEntity.this.progress[index];
                }
                if (index < 16) {
                    return CaviarProcessorBlockEntity.this.maxProgress[index - 8];
                }
                return 0;
            }

            public void set(int index, int valve) {
                if (index < 8) {
                    CaviarProcessorBlockEntity.this.progress[index] = valve;
                } else if (index < 16) {
                    CaviarProcessorBlockEntity.this.maxProgress[index - 8] = valve;
                }
            }

            public int getCount() {
                return 16;
            }
        };
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.TANK);
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(arg_0 -> ((CaviarProcessorBlockEntity)this).syncContents(arg_0));
        }
    }

    public IItemHandler getCaviarProcessorItemHandlerSide(Direction side) {
        return this.caviarProcessorItemHandlerSide;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.calculateMaxProgress();
            for (int i = 0; i < INPUT_SLOTS.length; ++i) {
                final int slot = INPUT_SLOTS[i];
                final ItemStack inputStack = this.itemHandler.getStackInSlot(slot);
                if (inputStack.isEmpty()) {
                    this.progress[i] = 0;
                    continue;
                }
                CaviarProcessorRecipeInput singleSlotInput = new CaviarProcessorRecipeInput(this, this.itemHandler, this.fluidHandler){

                    @Override
                    public ItemStack getItem(int index) {
                        if (index == slot) {
                            return inputStack;
                        }
                        return ItemStack.EMPTY;
                    }

                    @Override
                    public int size() {
                        return 1;
                    }
                };
                Optional<RecipeHolder> recipe = this.level.getRecipeManager().getAllRecipesFor((RecipeType)CaviarProcessorRecipe.Type.INSTANCE).stream().filter(match -> ((CaviarProcessorRecipe)match.value()).matches(singleSlotInput, this.level)).findFirst();
                if (recipe.isEmpty()) {
                    this.progress[i] = 0;
                    continue;
                }
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                if (this.progress[i] < this.maxProgress[i]) continue;
                this.fillOutputSlots((CaviarProcessorRecipe)recipe.get().value());
                this.itemHandler.extractItem(slot, 1, false);
                this.progress[i] = 0;
            }
        }
    }

    public void calculateMaxProgress() {
        ItemStack[] upgradeSlots;
        int baseMaxProgress = 300;
        int totalReduction = 0;
        HashMap<Item, Integer> speedUpgrades = new HashMap<Item, Integer>();
        speedUpgrades.put((Item)ResourceFishItems.SPEED_UPGRADE_1.get(), 40);
        speedUpgrades.put((Item)ResourceFishItems.SPEED_UPGRADE_2.get(), 80);
        speedUpgrades.put((Item)ResourceFishItems.SPEED_UPGRADE_3.get(), 120);
        ItemStack upgradeSlot1 = this.itemHandler.getStackInSlot(8);
        ItemStack upgradeSlot2 = this.itemHandler.getStackInSlot(9);
        ItemStack upgradeSlot3 = this.itemHandler.getStackInSlot(10);
        for (ItemStack upgradeSlot : upgradeSlots = new ItemStack[]{upgradeSlot1, upgradeSlot2, upgradeSlot3}) {
            Item upgradeItem;
            if (upgradeSlot.isEmpty() || !speedUpgrades.containsKey(upgradeItem = upgradeSlot.getItem())) continue;
            totalReduction += ((Integer)speedUpgrades.get(upgradeItem)).intValue();
        }
        Arrays.fill(this.maxProgress, Math.max(20, baseMaxProgress - totalReduction));
    }

    public void fillOutputSlots(CaviarProcessorRecipe recipe) {
        assert (this.level != null);
        List<ItemStack> results = recipe.rollResults(this.level.random);
        block0: for (ItemStack result : results) {
            for (int outputSlot : OUTPUTS_SLOTS) {
                int maxStackSize;
                int spaceLeft;
                ItemStack slotStack = this.itemHandler.getStackInSlot(outputSlot);
                if (slotStack.isEmpty()) {
                    this.itemHandler.setStackInSlot(outputSlot, result.copy());
                    result.setCount(0);
                    continue block0;
                }
                if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)result) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) <= 0) continue;
                int toAdd = Math.min(spaceLeft, result.getCount());
                slotStack.grow(toAdd);
                result.shrink(toAdd);
                if (result.isEmpty()) continue block0;
            }
        }
        if (!recipe.fluidStack().isEmpty()) {
            this.fluidHandler.fill(recipe.fluidStack(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean hasTankUpgrade() {
        Item tankUpgrade = (Item)ResourceFishItems.TANK_UPGRADE.get();
        for (int upgradeSlot : UPGRADE_SLOTS) {
            if (!this.itemHandler.getStackInSlot(upgradeSlot).is(tankUpgrade)) continue;
            return true;
        }
        return false;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.put("tank", (Tag)this.TANK.writeToNBT(provider, new CompoundTag()));
        compoundTag.putIntArray("progress", this.progress);
        compoundTag.putIntArray("maxProgress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.TANK.readFromNBT(provider, compoundTag.getCompound("tank"));
        this.progress = compoundTag.getIntArray("progress");
        this.maxProgress = compoundTag.getIntArray("maxProgress");
        super.loadAdditional(compoundTag, provider);
    }

    private int insertStackIntoSlots(ItemStackHandler itemHandler, ItemStack stack, int[] slots) {
        boolean hasRoundRobin = this.hasRoundRobinUpgrade();
        if (hasRoundRobin) {
            int remaining = stack.getCount();
            while (remaining > 0) {
                int slot = slots[this.roundRobinIndex % slots.length];
                ItemStack slotStack = itemHandler.getStackInSlot(slot);
                if (slotStack.isEmpty()) {
                    itemHandler.setStackInSlot(slot, stack.copyWithCount(1));
                    stack.shrink(1);
                    --remaining;
                } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack) && slotStack.getCount() < slotStack.getMaxStackSize()) {
                    slotStack.grow(1);
                    stack.shrink(1);
                    --remaining;
                }
                this.roundRobinIndex = (this.roundRobinIndex + 1) % slots.length;
                if (remaining != stack.getCount()) continue;
                break;
            }
            return remaining;
        }
        return this.insertStackNormal(itemHandler, stack, slots);
    }

    private int insertStackNormal(ItemStackHandler itemHandler, ItemStack stack, int[] slots) {
        ItemStack slotStack;
        for (int slot : slots) {
            int maxStackSize;
            int spaceLeft;
            slotStack = itemHandler.getStackInSlot(slot);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) <= 0) continue;
            int toAdd = Math.min(spaceLeft, stack.getCount());
            slotStack.grow(toAdd);
            stack.shrink(toAdd);
            if (!stack.isEmpty()) continue;
            return 0;
        }
        for (int slot : slots) {
            slotStack = itemHandler.getStackInSlot(slot);
            if (!slotStack.isEmpty()) continue;
            int toAdd = Math.min(stack.getMaxStackSize(), stack.getCount());
            itemHandler.setStackInSlot(slot, stack.copyWithCount(toAdd));
            stack.shrink(toAdd);
            if (!stack.isEmpty()) continue;
            return 0;
        }
        return stack.getCount();
    }

    private boolean hasRoundRobinUpgrade() {
        Item roundRobinUpgrade = (Item)ResourceFishItems.ROUND_ROBIN_UPGRADE.get();
        for (int upgradeSlot : UPGRADE_SLOTS) {
            if (!this.itemHandler.getStackInSlot(upgradeSlot).is(roundRobinUpgrade)) continue;
            return true;
        }
        return false;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }
}

