/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.forger;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.advancements.AdvancementBehaviour;
import plus.dragons.createdragonsplus.common.fluids.tank.ConfigurableFluidTank;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;
import plus.dragons.createenchantmentindustry.client.model.CEIPartialModels;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlockEntity;
import plus.dragons.createenchantmentindustry.common.processing.forger.BlazeForgerInventory;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

@FieldsNullabilityUnknownByDefault
public class BlazeForgerBlockEntity
extends BlazeExperienceBlockEntity {
    public static final int FORGING_TIME = 200;
    protected boolean special;
    protected boolean cursed;
    protected int processingTime = -1;
    protected final BlazeForgerInventory inventory = new BlazeForgerInventory(this);
    protected AdvancementBehaviour advancement;

    public BlazeForgerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (!(side != Direction.DOWN && side != null || this.isRemoved())) {
            return this.tanks.getCapability();
        }
        return null;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.advancement = new AdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.advancement);
    }

    @Override
    protected ConfigurableFluidTank createNormalTank(Consumer<FluidStack> fluidUpdateCallback) {
        return new ConfigurableFluidTank(((Integer)CEIConfig.fluids().blazeForgerFluidCapacity.get()).intValue(), fluidUpdateCallback).allowInsertion(fluidStack -> fluidStack.is(CEIFluids.EXPERIENCE));
    }

    @Override
    protected ConfigurableFluidTank createSpecialTank(Consumer<FluidStack> fluidUpdateCallback) {
        return new ConfigurableFluidTank(((Integer)CEIConfig.fluids().blazeForgerFluidCapacity.get()).intValue(), fluidUpdateCallback).forbidInsertion();
    }

    public boolean isActive() {
        return this.processingTime > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected PartialModel getHatModel(BlazeBurnerBlock.HeatLevel heatLevel) {
        return heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? CEIPartialModels.BLAZE_FORGER_HAT : CEIPartialModels.BLAZE_FORGER_HAT_SMALL;
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("ProcessingTime", this.processingTime);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.processingTime = compound.getInt("ProcessingTime");
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
    }

    public void initialize() {
        super.initialize();
    }

    public void destroy() {
        super.destroy();
        if (this.level != null) {
            ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
        }
    }

    public void tick() {
        int cost;
        boolean cursed;
        boolean special;
        super.tick();
        boolean update = false;
        boolean bl = special = this.getHeatLevelFromBlock() == BlazeBurnerBlock.HeatLevel.SEETHING;
        if (this.special != special) {
            this.special = special;
            update = true;
        }
        BlockPos strikePos = this.getStrikePos();
        boolean bl2 = cursed = special && !this.worldPosition.equals((Object)strikePos);
        if (this.cursed != cursed) {
            this.cursed = cursed;
            update = true;
        }
        if (this.level.isClientSide() && this.isVirtual()) {
            int cost2;
            if (update) {
                this.inventory.updateResult();
                this.notifyUpdate();
            }
            if ((cost2 = this.inventory.getExperienceCost()) > 0 && this.consumeExperience(cost2, special, true)) {
                if (this.processingTime < 0) {
                    this.processingTime = 50;
                    return;
                }
                if (this.processingTime > 0) {
                    --this.processingTime;
                    return;
                }
                this.consumeExperience(cost2, special, false);
                this.processingTime = -1;
                this.inventory.applyResult();
            } else if (this.processingTime != -1) {
                this.processingTime = -1;
            }
            return;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (update) {
            this.inventory.updateResult();
            this.notifyUpdate();
        }
        if ((cost = this.inventory.getExperienceCost()) > 0 && this.consumeExperience(cost, special, true)) {
            if (this.processingTime < 0) {
                this.processingTime = 200;
                this.notifyUpdate();
                return;
            }
            if (this.processingTime > 0) {
                --this.processingTime;
                this.notifyUpdate();
                return;
            }
            if (special && !cursed && this.strikeLightning(serverLevel, strikePos)) {
                this.advancement.trigger(CEIAdvancements.OSHA_VIOLATION.builtinTrigger());
                serverLevel.destroyBlock(this.worldPosition, false);
                serverLevel.setBlockAndUpdate(this.worldPosition, AllBlocks.LIT_BLAZE_BURNER.getDefaultState());
                this.setRemoved();
                return;
            }
            this.consumeExperience(cost, special, false);
            this.processingTime = -1;
            this.inventory.applyResult();
            this.notifyUpdate();
            this.level.playSound(null, this.worldPosition, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
        } else if (this.processingTime != -1) {
            this.processingTime = -1;
            this.notifyUpdate();
        }
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.inventory.hasRemainingOutput()) {
            return stack;
        }
        if (!stack.isEmpty()) {
            stack = this.inventory.insertItem(0, stack, simulate);
        }
        if (!stack.isEmpty()) {
            stack = this.inventory.insertItem(1, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(boolean simulate) {
        for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack extracted = this.inventory.extractItem(i, 1, simulate);
            if (extracted.isEmpty()) continue;
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        ChatFormatting style = this.special ? (this.cursed ? ChatFormatting.RED : ChatFormatting.BLUE) : ChatFormatting.GOLD;
        int cost = this.inventory.getExperienceCost();
        if (cost > 0) {
            added = true;
            LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
            CEILang.translate("gui.goggles.forging.cost", CEILang.number(cost).add(mb).style(style)).forGoggles(tooltip);
            for (int i = 0; i < 2; ++i) {
                ItemStack result = this.inventory.getResult(i);
                if (result.isEmpty()) continue;
                CEILang.translate("gui.goggles.forging.result", new Object[0]).forGoggles(tooltip);
                CEILang.item(result).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)result);
                if (enchantments.isEmpty()) continue;
                enchantments.addToTooltip(Item.TooltipContext.of((Level)this.level), component -> CEILang.builder().add(component).forGoggles(tooltip, 2), (TooltipFlag)TooltipFlag.NORMAL);
            }
        } else if (this.inventory.forgingCompleted()) {
            CEILang.translate("gui.goggles.forging.completed", new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
        } else if (!this.inventory.notEnoughItemToForge()) {
            if (this.inventory.incompatibleEnchantingTemplateType()) {
                CEILang.translate("gui.goggles.forging.invalid_template_type." + (this.special ? "normal" : "special"), new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
            } else {
                CEILang.translate("gui.goggles.forging.invalid_items", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
            }
        }
        return added;
    }
}

