/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenhopper.blockentity;

import de.cech12.woodenhopper.blockentity.WoodenHopperBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class NeoForgeWoodenHopperBlockEntity
extends WoodenHopperBlockEntity {
    private ItemStackHandler inventory = new ItemStackHandler();

    public NeoForgeWoodenHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory = new ItemStackHandler();
        if (!this.tryLoadLootTable(nbt)) {
            this.inventory.deserializeNBT(provider, nbt);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (!this.trySaveLootTable(compound)) {
            compound.merge(this.inventory.serializeNBT(provider));
        }
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return NonNullList.withSize((int)1, (Object)this.inventory.getStackInSlot(0));
    }

    protected void setItems(@NotNull NonNullList<ItemStack> itemsIn) {
        if (itemsIn.size() == 1) {
            this.inventory.setStackInSlot(0, (ItemStack)itemsIn.getFirst());
        }
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        ItemStack stack = this.inventory.extractItem(index, count, false);
        this.setChanged();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        this.unpackLootTable(null);
        ItemStack stack = this.inventory.getStackInSlot(index);
        this.inventory.setStackInSlot(index, ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.unpackLootTable(null);
        this.inventory.setStackInSlot(index, stack);
        this.setChanged();
    }

    @Override
    protected ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, Object destInventoryObj, ItemStack stack) {
        IItemHandler destInventory = (IItemHandler)destInventoryObj;
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = this.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack result = stack;
        if (!destInventory.insertItem(slot, stack, true).equals(stack)) {
            boolean inventoryWasEmpty = this.isEmpty(destInventory);
            result = destInventory.insertItem(slot, stack, false);
            if (result.getCount() < stack.getCount()) {
                this.updateCooldown(inventoryWasEmpty, source, destination);
            }
        }
        return result;
    }

    @Override
    protected Optional<Pair<Object, Object>> getItemHandler(Level level, double x, double y, double z, Direction side) {
        Block block;
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState state = level.getBlockState(blockpos);
        if (state.hasBlockEntity()) {
            WorldlyContainer container;
            IItemHandler handler;
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity != null && (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockpos, state, blockEntity, (Object)side)) != null) {
                return Optional.of(ImmutablePair.of((Object)handler, (Object)blockEntity));
            }
            if (blockEntity instanceof WorldlyContainer) {
                container = (WorldlyContainer)blockEntity;
                return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(container, side), (Object)state));
            }
            if (blockEntity instanceof Container) {
                container = (Container)blockEntity;
                return Optional.of(ImmutablePair.of((Object)new InvWrapper((Container)container), (Object)state));
            }
        }
        if ((block = state.getBlock()) instanceof WorldlyContainerHolder) {
            return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(((WorldlyContainerHolder)block).getContainer(state, (LevelAccessor)level, blockpos), side), (Object)state));
        }
        List<Entity> list = NeoForgeWoodenHopperBlockEntity.getAllAliveEntitiesAt(level, x, y, z, entity -> entity instanceof Container || !(entity instanceof LivingEntity) && entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side) != null);
        if (!list.isEmpty()) {
            Entity entity2 = list.get(level.random.nextInt(list.size()));
            IItemHandler cap = (IItemHandler)entity2.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
            if (cap != null) {
                return Optional.of(ImmutablePair.of((Object)cap, (Object)entity2));
            }
            if (entity2 instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)entity2;
                return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(container, side), (Object)entity2));
            }
            if (entity2 instanceof Container) {
                Container containerEntity = (Container)entity2;
                return Optional.of(ImmutablePair.of((Object)new InvWrapper(containerEntity), (Object)entity2));
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean isNotFull(Object itemHandlerObj) {
        IItemHandler itemHandler = (IItemHandler)itemHandlerObj;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean pullItemsFromItemHandler(Object itemHandler) {
        IItemHandler handler = (IItemHandler)itemHandler;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.isEmpty()) continue;
            for (int j = 0; j < this.getContainerSize(); ++j) {
                ItemStack destStack = this.getItem(j);
                if (!this.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= this.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.isEmpty()) {
                    this.setItem(j, extractItem);
                } else {
                    destStack.grow(1);
                    this.setItem(j, destStack);
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object getOwnItemHandler() {
        return this.inventory;
    }
}

