/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BagItem
extends Item {
    private HatEntry.HatSeason hatSeason = HatEntry.HatSeason.NONE;
    private boolean seasonal = false;
    private Rarity rarity = Rarity.COMMON;
    private final List<HatItem> availableHatList = new ArrayList<HatItem>();
    private WeightedListInt availableHatListWeighted = null;

    public BagItem(Rarity rarity) {
        super(new Item.Properties().rarity(rarity));
        this.rarity = rarity;
    }

    public BagItem(HatEntry.HatSeason hatSeason) {
        super(new Item.Properties().rarity(Rarity.EPIC));
        this.hatSeason = hatSeason;
        this.seasonal = true;
        this.rarity = Rarity.EPIC;
    }

    public static SoundEvent getUnwrapFinishSound() {
        return (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        player.playSound(BagItem.getUnwrapFinishSound(), 1.0f, 1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.4f);
        if (!level.isClientSide()) {
            Item item;
            if (!this.seasonal && HatEntry.HatSeason.getSeason() != HatEntry.HatSeason.NONE && level.getRandom().nextFloat() * 100.0f < (float)SimpleHatsConfigAbstract.seasonalBagChance() && (item = BagItem.getSeasonalBag()) != Items.AIR) {
                player.spawnAtLocation((ItemLike)item);
            }
            if ((item = this.getBagResult(level, itemStack)) != Items.AIR) {
                player.spawnAtLocation((ItemLike)item);
            }
        }
        itemStack.shrink(1);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private static Item getSeasonalBag() {
        switch (HatEntry.HatSeason.getSeason()) {
            case EASTER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagEaster();
            }
            case SUMMER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagSummer();
            }
            case HALLOWEEN: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagHalloween();
            }
            case FESTIVE: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagFestive();
            }
        }
        Constants.LOG.error("Failed to get seasonal bag type.");
        return Items.AIR;
    }

    private Item getBagResult(Level level, ItemStack bagStack) {
        if (this.availableHatList.isEmpty()) {
            for (HatItem hat : SimpleHatsCommon.MOD_REGISTRY.getHatList()) {
                if (hat.getHatEntry().getHatRarity() != this.rarity && !this.seasonal || hat.getHatEntry().getHatWeight() == 0 || hat.getHatEntry().getHatSeason() != this.hatSeason) continue;
                this.availableHatList.add(hat);
            }
            if (this.availableHatList.isEmpty()) {
                Constants.LOG.error("Failed to populate " + String.valueOf(this.getName(bagStack)) + " loot list.");
                return Items.AIR;
            }
        }
        if (this.availableHatListWeighted == null) {
            try {
                SimpleWeightedRandomList.Builder<IntProvider> builder = this.generateSimpleWeightedList((SimpleWeightedRandomList.Builder<IntProvider>)SimpleWeightedRandomList.builder().add((Object)ConstantInt.of((int)0), this.availableHatList.get(0).getHatEntry().getHatWeight()), 1);
                this.availableHatListWeighted = new WeightedListInt(builder.build());
            }
            catch (Exception ex) {
                Constants.LOG.error("Failed to generate " + String.valueOf(this.getName(bagStack)) + " weighted loot table: " + String.valueOf(ex));
                return Items.AIR;
            }
        }
        return (Item)this.availableHatList.get(this.availableHatListWeighted.sample(level.getRandom()));
    }

    private SimpleWeightedRandomList.Builder<IntProvider> generateSimpleWeightedList(SimpleWeightedRandomList.Builder<IntProvider> list, int i) {
        if (i < this.availableHatList.size()) {
            list.add((Object)ConstantInt.of((int)i), this.availableHatList.get(i).getHatEntry().getHatWeight());
            list = this.generateSimpleWeightedList(list, ++i);
        }
        return list;
    }
}

