/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.entity;

import com.mojang.serialization.DynamicOps;
import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.item.HatItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class HatDisplay
extends LivingEntity {
    private final NonNullList<ItemStack> hatItemSlots = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(HatDisplay.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public long lastHit;

    public HatDisplay(EntityType<? extends HatDisplay> type, Level level) {
        super(type, level);
    }

    public HatDisplay(Level level, double x, double y, double z) {
        this(SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity(), level);
        this.setPos(x, y, z);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return (ItemStack)this.hatItemSlots.get(0);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        if (!stack.isEmpty() && !(stack.getItem() instanceof HatItem)) {
            Constants.LOG.error("Attempted to place non-hat item \"" + String.valueOf(stack.getItem().getName(stack)) + "\" on hat display stand");
            return;
        }
        this.verifyEquippedItem(stack);
        this.onEquipItem(EquipmentSlot.HEAD, (ItemStack)this.hatItemSlots.set(0, (Object)stack), stack);
    }

    public boolean canTakeItem(ItemStack itemStack) {
        return this.getItemBySlot(null).isEmpty();
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.hatItemSlots;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ListTag listTag = new ListTag();
        ItemStack itemStack = (ItemStack)this.hatItemSlots.get(0);
        Tag compoundTag = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)itemStack).mapOrElse(e -> e, $ -> new CompoundTag());
        listTag.add((Object)compoundTag);
        compound.put("HatItem", (Tag)listTag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("HatItem", 9)) {
            ListTag listTag = compound.getList("HatItem", 10);
            this.hatItemSlots.set(0, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)((Tag)listTag.getFirst())).orElse(ItemStack.EMPTY));
        }
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
    }

    public InteractionResult interactAt(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is(Items.NAME_TAG)) {
            if (player.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            if (player.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (this.swapItem(player, itemStack, hand)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean swapItem(Player player, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack = this.getItemBySlot(null);
        if (!stack.isEmpty() && !(stack.getItem() instanceof HatItem)) {
            return false;
        }
        if (player.hasInfiniteMaterials() && itemStack.isEmpty() && !stack.isEmpty()) {
            ItemStack itemStack2 = stack.copy();
            itemStack2.setCount(1);
            this.setItemSlot(null, itemStack2);
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemStack.isEmpty()) {
                return false;
            }
            ItemStack itemStack1 = stack.copy();
            itemStack1.setCount(1);
            this.setItemSlot(null, itemStack1);
            stack.shrink(1);
            return true;
        }
        this.setItemSlot(null, stack);
        player.setItemInHand(hand, itemStack);
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.isRemoved()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                    this.kill();
                    return false;
                }
                if (!this.isInvulnerableTo(source)) {
                    if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                        this.onBreak(serverLevel, source);
                        this.kill();
                        return false;
                    }
                    if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                        if (this.isOnFire()) {
                            this.updateHealth(serverLevel, source, 0.15f);
                        } else {
                            this.igniteForSeconds(5.0f);
                        }
                        return false;
                    }
                    if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                        this.updateHealth(serverLevel, source, 4.0f);
                        return false;
                    }
                    boolean flag1 = source.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                    boolean flag = source.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                    if (!flag1 && !flag) {
                        return false;
                    }
                    Entity var7 = source.getEntity();
                    if (var7 instanceof Player) {
                        Player player = (Player)var7;
                        if (!player.getAbilities().mayBuild) {
                            return false;
                        }
                    }
                    if (source.isCreativePlayer()) {
                        this.playBreakSound();
                        this.spawnBreakParticles();
                        this.kill();
                        return true;
                    }
                    long i = serverLevel.getGameTime();
                    if (i - this.lastHit > 5L && !flag) {
                        serverLevel.broadcastEntityEvent((Entity)this, (byte)32);
                        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                        this.lastHit = i;
                    } else {
                        this.breakAndDropItem(serverLevel, source);
                        this.spawnBreakParticles();
                        this.kill();
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 32) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void spawnBreakParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.66), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void updateHealth(ServerLevel level, DamageSource source, float dmg) {
        float f = this.getHealth() - dmg;
        if (f <= 0.5f) {
            this.onBreak(level, source);
            this.kill();
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        }
    }

    private void breakAndDropItem(ServerLevel level, DamageSource source) {
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatDisplayItem()));
        this.onBreak(level, source);
    }

    private void onBreak(ServerLevel level, DamageSource source) {
        this.playBreakSound();
        this.dropAllDeathLoot(level, source);
        ItemStack itemStack = (ItemStack)this.hatItemSlots.get(0);
        if (!itemStack.isEmpty()) {
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemStack);
            this.hatItemSlots.set(0, (Object)ItemStack.EMPTY);
        }
    }

    private void playBreakSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    protected float tickHeadTurn(float f1, float f2) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public Vec3 getVehicleAttachmentPoint(Entity vehicle) {
        return new Vec3(0.0, 0.1, 0.0);
    }

    public void setYBodyRot(float offset) {
        this.yBodyRotO = this.yRotO = offset;
        this.yHeadRotO = this.yHeadRot = offset;
    }

    public void setYHeadRot(float rotation) {
        this.yBodyRotO = this.yRotO = rotation;
        this.yHeadRotO = this.yHeadRot = rotation;
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    public boolean skipAttackInteraction(Entity entity) {
        return entity instanceof Player && !this.level().mayInteract((Player)entity, this.blockPosition());
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getType().getDimensions();
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatDisplayItem());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_CLIENT_FLAGS.equals(pKey)) {
            this.refreshDimensions();
            this.blocksBuilding = true;
        }
        super.onSyncedDataUpdated(pKey);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLIENT_FLAGS, (Object)0);
    }
}

