/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats;

import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.HatJson;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.loot.LootRegistry;
import fonnymunkey.simplehats.util.HatEntry;
import fonnymunkey.simplehats.util.TagInjector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public class EventHandler {

    @EventBusSubscriber(modid="simplehats", bus=EventBusSubscriber.Bus.GAME)
    public static class EventHandlerNeoForge {
        @SubscribeEvent
        public static void onLootTableLoadEvent(LootTableLoadEvent event) {
            if (SimpleHatsConfigAbstract.enableChestLoot() && LootRegistry.LOOT_HATINJECT_CHEST.contains(event.getName())) {
                LootPool.Builder pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagCommon()).setWeight(SimpleHatsConfigAbstract.chestCommonWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagUncommon()).setWeight(SimpleHatsConfigAbstract.chestUncommonWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagRare()).setWeight(SimpleHatsConfigAbstract.chestRareWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEpic()).setWeight(SimpleHatsConfigAbstract.chestEpicWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ItemStack.EMPTY.getItem()).setWeight(SimpleHatsConfigAbstract.chestNoneWeight())).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
                event.getTable().addPool(pool.build());
            } else if (SimpleHatsConfigAbstract.enableMobLoot() && LootRegistry.LOOT_HATINJECT_ENTITY.contains(event.getName())) {
                LootPool.Builder pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagCommon()).setWeight(SimpleHatsConfigAbstract.entityCommonWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagUncommon()).setWeight(SimpleHatsConfigAbstract.entityUncommonWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagRare()).setWeight(SimpleHatsConfigAbstract.entityRareWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEpic()).setWeight(SimpleHatsConfigAbstract.entityEpicWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ItemStack.EMPTY.getItem()).setWeight(SimpleHatsConfigAbstract.entityNoneWeight())).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemKilledByPlayerCondition.killedByPlayer());
                event.getTable().addPool(pool.build());
            }
        }
    }

    @EventBusSubscriber(modid="simplehats", bus=EventBusSubscriber.Bus.MOD)
    public static class EventHandlerMod {
        @SubscribeEvent
        public static void registerHats(RegisterEvent event) {
            if (event.getRegistryKey().equals(Registries.ITEM)) {
                for (HatEntry entry : HatJson.getHatList()) {
                    HatItem hat = entry.getHatDyeSettings().getUseDye() ? new HatItemDyeable(entry) : new HatItem(entry);
                    event.register(Registries.ITEM, ResourceLocation.tryBuild((String)"simplehats", (String)entry.getHatName()), () -> hat);
                    SimpleHatsCommon.MOD_REGISTRY.getHatList().add(hat);
                    if (!(hat instanceof HatItemDyeable)) continue;
                    CauldronInteraction.WATER.map().put(hat, CauldronInteraction.DYED_ITEM);
                    TagInjector.inject(BuiltInRegistries.ITEM, ItemTags.DYEABLE.location(), new Item[]{hat});
                }
                Constants.LOG.info("Generated " + SimpleHatsCommon.MOD_REGISTRY.getHatList().size() + " hat items from hat entries.");
                TagInjector.inject(BuiltInRegistries.ITEM, SimpleHatsCommon.ALL_HATS.location(), SimpleHatsCommon.MOD_REGISTRY.getHatList().stream().map(hatItem -> hatItem).toList());
            }
        }

        @SubscribeEvent
        public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put(SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity(), HatDisplay.createAttributes().build());
        }
    }
}

