/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.everythingcopper.common.block.entity.WeatheringStationBlockEntity;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WeatheringStation
extends BaseEntityBlock {
    public static final MapCodec<WeatheringStation> CODEC = WeatheringStation.simpleCodec(WeatheringStation::new);
    public static final BooleanProperty WET = BooleanProperty.create((String)"wet");
    private static final VoxelShape OUTER_SHAPE = Shapes.block();
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)OUTER_SHAPE, (VoxelShape)Block.box((double)2.0, (double)Math.max(2, 1), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public WeatheringStation(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WET, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WET});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new WeatheringStationBlockEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.isClientSide ? null : WeatheringStation.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.WEATHERING_STATION.get()), WeatheringStationBlockEntity::tick);
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState p_51973_, BlockGetter p_51974_, BlockPos p_51975_, CollisionContext p_51976_) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState p_51969_, BlockGetter p_51970_, BlockPos p_51971_) {
        return OUTER_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState p_51990_, BlockGetter p_51991_, BlockPos p_51992_, CollisionContext p_51993_) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof WeatheringStationBlockEntity) {
            WeatheringStationBlockEntity weatheringStationBlockEntity = (WeatheringStationBlockEntity)blockEntity;
            AtomicBoolean hasInteracted = new AtomicBoolean(pLevel.isClientSide());
            if (!pLevel.isClientSide()) {
                ItemStack outputItem = weatheringStationBlockEntity.inventoryHandler.getStackInSlot(WeatheringStationBlockEntity.SLOT_OUTPUT);
                if (pStack.isEmpty()) {
                    if (!outputItem.isEmpty()) {
                        pPlayer.setItemInHand(pHand, outputItem.copy());
                        outputItem.setCount(0);
                        hasInteracted.set(true);
                    } else {
                        ItemStack inputItem = weatheringStationBlockEntity.inventoryHandler.getStackInSlot(WeatheringStationBlockEntity.SLOT_INPUT);
                        pPlayer.setItemInHand(pHand, inputItem.copy());
                        inputItem.setCount(0);
                        hasInteracted.set(true);
                    }
                } else if (ItemStack.isSameItemSameComponents((ItemStack)pStack, (ItemStack)outputItem)) {
                    int grabbedCount = Math.min(pStack.getMaxStackSize() - pStack.getCount(), outputItem.getCount());
                    pStack.grow(grabbedCount);
                    outputItem.shrink(grabbedCount);
                    hasInteracted.set(true);
                } else if (weatheringStationBlockEntity.inventoryHandler.isItemValid(WeatheringStationBlockEntity.SLOT_INPUT, pStack)) {
                    ItemStack leftOver = weatheringStationBlockEntity.inventoryHandler.insertItem(WeatheringStationBlockEntity.SLOT_INPUT, pStack, false);
                    pPlayer.setItemInHand(pHand, leftOver);
                    hasInteracted.set(true);
                } else if (pStack.is(Items.WATER_BUCKET) && weatheringStationBlockEntity.fluidInventory.getTankCapacity(0) - weatheringStationBlockEntity.fluidInventory.getFluidInTank(0).getAmount() >= 1000) {
                    weatheringStationBlockEntity.fluidInventory.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                    if (!pPlayer.isCreative()) {
                        pPlayer.setItemInHand(pHand, pStack.getCraftingRemainingItem());
                    }
                    hasInteracted.set(true);
                }
            }
            if (hasInteracted.get()) {
                weatheringStationBlockEntity.setChanged();
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof WeatheringStationBlockEntity) {
            WeatheringStationBlockEntity weatheringStationBlockEntity = (WeatheringStationBlockEntity)tileEntity;
            for (int slot = 0; slot < weatheringStationBlockEntity.inventoryHandler.getSlots(); ++slot) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)weatheringStationBlockEntity.inventoryHandler.getStackInSlot(slot));
            }
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }
}

