/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.inventory.CopperAnvilMenu;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CopperAnvil
extends AnvilBlock
implements IWeatheringBlock {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.repair");
    private final WeatheringCopper.WeatherState weatherState;
    public static Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK;

    private static void buildAnvilMap() {
        if (NEXT_BY_BLOCK == null) {
            NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)ModBlocks.COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_OXIDIZED_COPPER_ANVIL.get())).build());
        }
    }

    public CopperAnvil(WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = state;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        this.changeOverTime(blockState, level, blockPos, random);
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return WeatheringCopper.getNext((Block)blockState.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new CopperAnvilMenu(id, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    @Nullable
    public static BlockState damage(BlockState blockState) {
        CopperAnvil.buildAnvilMap();
        Optional<BlockState> next = Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)blockState.getBlock())).map(block -> block.withPropertiesOf(blockState));
        return next.orElse(null);
    }
}

