/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class ProcessFarmProcessor
extends StructureProcessor {
    private static final ProcessFarmProcessor INSTANCE = new ProcessFarmProcessor();
    public static final MapCodec<ProcessFarmProcessor> CODEC = MapCodec.unit((Object)((Object)INSTANCE));
    @Nullable
    private final BlockState copperLantern;
    private final Set<Block> validBlocks;
    private BlockPos lastPos = BlockPos.ZERO;
    private boolean lastPlaced = false;

    public ProcessFarmProcessor() {
        this.copperLantern = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)"suppsquared:copper_lantern")).map(c -> (BlockState)((BlockState)c.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).orElse(null);
        this.validBlocks = Set.of(Blocks.OAK_PLANKS, Blocks.OAK_STAIRS, Blocks.OAK_SLAB, Blocks.RED_TERRACOTTA, Blocks.STRIPPED_OAK_LOG, Blocks.OAK_LOG);
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos arg2, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockPos blockPos = relativeBlockInfo.pos();
        BlockState replace = null;
        replace = this.maybeReplaceLantern(relativeBlockInfo, settings, blockPos);
        if (replace == null) {
            replace = this.maybePlaceCobweb(relativeBlockInfo, settings);
        }
        if (replace == null) {
            replace = this.maybePlaceMoss(relativeBlockInfo, settings);
        }
        return replace != null ? new StructureTemplate.StructureBlockInfo(blockPos, replace, relativeBlockInfo.nbt()) : relativeBlockInfo;
    }

    private BlockState maybePlaceMoss(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        RandomSource randomSource;
        BlockState replace = null;
        if (relativeBlockInfo.state().is(Blocks.COBBLESTONE) && (double)(randomSource = settings.getRandom(relativeBlockInfo.pos())).nextFloat() < 0.25) {
            replace = Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
        return replace;
    }

    private BlockState maybeReplaceLantern(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, BlockPos blockPos) {
        BlockState replace = null;
        if (relativeBlockInfo.state().is(Blocks.LANTERN)) {
            RandomSource randomSource = settings.getRandom(relativeBlockInfo.pos());
            if (blockPos.closerThan((Vec3i)this.lastPos, 10.0)) {
                if (this.lastPlaced) {
                    this.lastPlaced = false;
                    replace = Blocks.AIR.defaultBlockState();
                } else if (this.copperLantern != null) {
                    replace = this.copperLantern.rotate(settings.getRotation());
                }
            } else if (randomSource.nextBoolean()) {
                this.lastPlaced = true;
                if (this.copperLantern != null) {
                    replace = this.copperLantern.rotate(settings.getRotation());
                }
            } else {
                this.lastPlaced = false;
                replace = Blocks.AIR.defaultBlockState();
            }
            this.lastPos = blockPos;
        }
        return replace;
    }

    private BlockState maybePlaceCobweb(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        RandomSource randomSource;
        BlockState replace = null;
        if (this.validBlocks.contains(relativeBlockInfo.state().getBlock()) && (double)(randomSource = settings.getRandom(relativeBlockInfo.pos())).nextFloat() < 0.07) {
            replace = Blocks.COBWEB.defaultBlockState();
        }
        return replace;
    }

    protected StructureProcessorType<?> getType() {
        return ModRegistry.FARM_PROCESSOR.get();
    }
}

