/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.network;

import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.entity.ICustomPumpkinHolder;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record SyncSnowGolemPumpkinPacket(int entityID, ItemStack pumpkin) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, SyncSnowGolemPumpkinPacket> CODEC = Message.makeType((ResourceLocation)HauntedHarvest.res("sync_equipped_quiver"), SyncSnowGolemPumpkinPacket::new);

    public SyncSnowGolemPumpkinPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readVarInt(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
    }

    public <A extends Entity> SyncSnowGolemPumpkinPacket(A entity) {
        this(entity, (ICustomPumpkinHolder)entity);
    }

    public SyncSnowGolemPumpkinPacket(Entity entity, ICustomPumpkinHolder qe) {
        this(entity.getId(), qe.hauntedharvest$getCustomPumpkin());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.entityID);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.pumpkin);
    }

    public void handle(Message.Context context) {
        if (context.getDirection() == Message.NetworkDir.SERVER_BOUND) {
            ICustomPumpkinHolder qe;
            Entity e = context.getPlayer().level().getEntity(this.entityID);
            if (e instanceof ICustomPumpkinHolder && !(qe = (ICustomPumpkinHolder)e).hauntedharvest$getCustomPumpkin().isEmpty()) {
                NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SyncSnowGolemPumpkinPacket(e, qe));
            }
        } else {
            this.handleSyncPumpkin(this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleSyncPumpkin(SyncSnowGolemPumpkinPacket message) {
        ClientLevel l = Minecraft.getInstance().level;
        Entity e = l.getEntity(message.entityID());
        if (e instanceof ICustomPumpkinHolder) {
            ICustomPumpkinHolder qe = (ICustomPumpkinHolder)e;
            qe.hauntedharvest$setCustomPumpkin(message.pumpkin);
        }
    }
}

