/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.network;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;

public class ServerBoundCarvePumpkinPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundCarvePumpkinPacket> TYPE = Message.makeType((ResourceLocation)HauntedHarvest.res("carve_pumpkin"), ServerBoundCarvePumpkinPacket::new);
    private final BlockPos pos;
    private final boolean[][] pixels;
    private final Direction dir;

    public ServerBoundCarvePumpkinPacket(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dir = Direction.from2DDataValue((int)buf.readVarInt());
        this.pixels = new boolean[16][16];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = ServerBoundCarvePumpkinPacket.readBoolArray((ByteBuf)buf);
        }
    }

    private static boolean[] readBoolArray(ByteBuf buffer) {
        int maxSize;
        int i = VarInt.read((ByteBuf)buffer);
        if (i > (maxSize = buffer.readableBytes())) {
            throw new DecoderException("ByteArray with size " + i + " is bigger than allowed " + maxSize);
        }
        boolean[] bs = new boolean[i];
        for (int j = 0; j < i; ++j) {
            bs[j] = buffer.readBoolean();
        }
        return bs;
    }

    public ServerBoundCarvePumpkinPacket(BlockPos pos, boolean[][] pixels, Direction dir) {
        this.pos = pos;
        this.pixels = pixels;
        this.dir = dir;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.dir.get2DDataValue());
        for (boolean[] pixel : this.pixels) {
            ServerBoundCarvePumpkinPacket.writeBoolArray((ByteBuf)buf, pixel);
        }
    }

    private static void writeBoolArray(ByteBuf buffer, boolean[] bs) {
        VarInt.write((ByteBuf)buffer, (int)bs.length);
        for (boolean b : bs) {
            buffer.writeBoolean(b);
        }
    }

    public void handle(Message.Context context) {
        ModCarvedPumpkinBlockTile pumpkin;
        BlockEntity blockEntity;
        BlockPos pos;
        ServerPlayer player;
        Level level;
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).level()).hasChunkAt(pos = this.pos) && (blockEntity = level.getBlockEntity(pos)) instanceof ModCarvedPumpkinBlockTile && (pumpkin = (ModCarvedPumpkinBlockTile)blockEntity).tryAcceptingClientPixels(player, this.pixels, this.dir)) {
            pumpkin.setChanged();
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

