/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.mixins;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements IHalloweenVillager {
    @Unique
    private final Map<UUID, Integer> hauntedharvest$adultCandyCooldown = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private int hauntedharvest$conversionTime = -1;

    protected VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Brain<Villager> getBrain();

    @Inject(method={"customServerAiStep()V"}, at={@At(value="RETURN")})
    protected void customServerAiStep(CallbackInfo ci) {
        for (Map.Entry<UUID, Integer> e : this.hauntedharvest$adultCandyCooldown.entrySet()) {
            UUID id = e.getKey();
            Integer i = e.getValue();
            if (i <= 0) {
                this.hauntedharvest$adultCandyCooldown.remove(id);
                continue;
            }
            this.hauntedharvest$adultCandyCooldown.put(id, i - 1);
        }
    }

    @Override
    public boolean hauntedharvest$isEntityOnCooldown(Entity e) {
        return this.hauntedharvest$adultCandyCooldown.containsKey(e.getUUID());
    }

    @Override
    public void hauntedharvest$setEntityOnCooldown(Entity e) {
        this.hauntedharvest$setEntityOnCooldown(e, 50);
    }

    @Override
    public void hauntedharvest$setEntityOnCooldown(Entity e, int cooldownSec) {
        this.hauntedharvest$adultCandyCooldown.put(e.getUUID(), 20 * (cooldownSec + e.level().random.nextInt(20)));
    }

    @Inject(method={"wantsToPickUp(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void wantsToPickUp(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (HalloweenVillagerAI.isTrickOrTreater((LivingEntity)this) && HalloweenVillagerAI.isCandyOrApple(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    public void onItemPickup(ItemEntity itemEntity) {
        super.onItemPickup(itemEntity);
        if (HalloweenVillagerAI.isTrickOrTreater((LivingEntity)this) && HalloweenVillagerAI.isCandyOrApple(itemEntity.getItem())) {
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)14);
            }
        }
    }

    @Override
    public void hauntedharvest$startConverting() {
        if (!this.hauntedharvest$isConverting()) {
            this.hauntedharvest$conversionTime = 1200;
            this.level().broadcastEntityEvent((Entity)this, (byte)16);
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200, 2));
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        GlobalPos globalpos;
        tag.putInt("ConversionTime", this.hauntedharvest$conversionTime);
        if (this.getBrain().hasMemoryValue(ModRegistry.PUMPKIN_POS.get()) && (globalpos = (GlobalPos)this.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get()).dimension() == this.level().dimension()) {
            tag.put("Pumpkin", NbtUtils.writeBlockPos((BlockPos)globalpos.pos()));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        this.hauntedharvest$conversionTime = compoundNBT.getInt("ConversionTime");
        if (compoundNBT.contains("Pumpkin")) {
            try {
                this.getBrain().setMemory(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)((BlockPos)NbtUtils.readBlockPos((CompoundTag)compoundNBT, (String)"Pumpkin").get())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hauntedharvest$isConverting() {
        return this.hauntedharvest$conversionTime > 0;
    }

    @Unique
    private void doWitchConversion() {
        float yBodyRot = this.yBodyRot;
        float yHeadRot = this.yHeadRot;
        float yBodyRotO = this.yBodyRotO;
        float yHeadRotO = this.yHeadRotO;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            double d0;
            ItemStack itemstack = this.getItemBySlot(equipmentSlot);
            if (!itemstack.isEmpty() && (d0 = (double)this.getEquipmentDropChance(equipmentSlot)) > 1.0) {
                this.spawnAtLocation(itemstack);
            }
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
        Witch witch = (Witch)this.convertTo(EntityType.WITCH, true);
        if (witch != null) {
            witch.yBodyRot = yBodyRot;
            witch.yHeadRot = yHeadRot;
            witch.yHeadRotO = yHeadRotO;
            witch.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
            ForgeHelper.fireOnLivingConvert((LivingEntity)this, (LivingEntity)witch);
        }
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1027, this.blockPosition(), 0);
        }
    }

    @Inject(method={"handleEntityEvent(B)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleEntityEvent(byte pId, CallbackInfo ci) {
        if (pId == 16) {
            this.hauntedharvest$conversionTime = 1200;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            ci.cancel();
        } else if (pId == 26) {
            if (this.getPose() == Pose.SLEEPING) {
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
            }
            ci.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi() && this.hauntedharvest$isConverting()) {
            --this.hauntedharvest$conversionTime;
            if (this.hauntedharvest$conversionTime == 0) {
                this.doWitchConversion();
            }
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void interact(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.is(Items.MILK_BUCKET) && this.hauntedharvest$isConverting()) {
            this.hauntedharvest$conversionTime = -1;
            Level level = this.level();
            itemstack.finishUsingItem(level, (LivingEntity)this);
            this.eat(level, itemstack);
            pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)Items.BUCKET));
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }
}

