/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class PumpkinCarvingData
implements TooltipComponent,
TooltipProvider {
    private static final Component WAXED_TOOLTIP = Component.translatable((String)"message.hauntedharvest.waxed").withStyle(ChatFormatting.GRAY);
    private static final int SIZE = 16;
    public static final Codec<boolean[][]> PIXEL_CODEC = Codec.LONG_STREAM.xmap(LongStream::toArray, Arrays::stream).xmap(PumpkinCarvingData::unpack, PumpkinCarvingData::pack);
    public static final Codec<PumpkinCarvingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PIXEL_CODEC.fieldOf("values").forGetter(v -> v.pixels), (App)PumpkinType.REGISTRY.holderByNameCodec().fieldOf("type").forGetter(v -> v.type), (App)Codec.BOOL.fieldOf("waxed").forGetter(v -> v.waxed)).apply((Applicative)instance, PumpkinCarvingData::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, long[]> LONG_ARRAY = new StreamCodec<RegistryFriendlyByteBuf, long[]>(){

        public long[] decode(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readByte();
            long[] values = new long[size];
            for (int i = 0; i < size; ++i) {
                values[i] = buffer.readLong();
            }
            return values;
        }

        public void encode(RegistryFriendlyByteBuf buffer, long[] value) {
            buffer.writeByte(value.length);
            for (long l : value) {
                buffer.writeLong(l);
            }
        }
    };
    private static final StreamCodec<RegistryFriendlyByteBuf, boolean[][]> PIXELS_CODEC = LONG_ARRAY.map(PumpkinCarvingData::unpack, PumpkinCarvingData::pack);
    public static final StreamCodec<RegistryFriendlyByteBuf, PumpkinCarvingData> STREAM_CODEC = StreamCodec.composite(PIXELS_CODEC, data -> data.pixels, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)PumpkinType.REGISTRY.key()), data -> data.type, (StreamCodec)ByteBufCodecs.BOOL, data -> data.waxed, PumpkinCarvingData::new);
    private final boolean[][] pixels;
    private final boolean waxed;
    private final Holder<PumpkinType> type;
    private final int cachedHashCode;

    PumpkinCarvingData(boolean[][] pixels, Holder<PumpkinType> type, boolean waxed) {
        this.pixels = pixels;
        this.type = type;
        this.waxed = waxed;
        this.cachedHashCode = Objects.hash(Arrays.deepHashCode((Object[])pixels), type, waxed);
    }

    public static PumpkinCarvingData of(boolean[][] pixels, Holder<PumpkinType> pumpkinType, boolean waxed) {
        return new PumpkinCarvingData(pixels, pumpkinType, waxed);
    }

    public static PumpkinCarvingData empty(Holder<PumpkinType> pumpkinType) {
        return new PumpkinCarvingData(new boolean[16][16], pumpkinType, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PumpkinCarvingData)) {
            return false;
        }
        PumpkinCarvingData that = (PumpkinCarvingData)o;
        return this.type == that.type && this.waxed == that.waxed && Objects.deepEquals(this.pixels, that.pixels);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.waxed) {
            tooltipAdder.accept(WAXED_TOOLTIP);
        }
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public Holder<PumpkinType> getType() {
        return this.type;
    }

    public boolean hasSamePixels(boolean[][] pixels) {
        return Arrays.deepEquals((Object[])this.pixels, (Object[])pixels);
    }

    public boolean isEmpty() {
        boolean[][] blArray = this.pixels;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] row;
            for (boolean value : row = blArray[i]) {
                if (!value) continue;
                return false;
            }
        }
        return true;
    }

    public boolean getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public boolean[][] clonePixels() {
        boolean[][] newPixels = new boolean[16][16];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(this.pixels[i], 0, newPixels[i], 0, 16);
        }
        return newPixels;
    }

    public PumpkinCarvingData makeCleared() {
        return new PumpkinCarvingData(new boolean[16][16], this.type, this.waxed);
    }

    public PumpkinCarvingData withPixel(int x, int y, boolean b) {
        boolean[][] newPixels = new boolean[16][16];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(this.pixels[i], 0, newPixels[i], 0, 16);
        }
        newPixels[x][y] = b;
        return new PumpkinCarvingData(newPixels, this.type, this.waxed);
    }

    public PumpkinCarvingData withWaxed(boolean b) {
        return new PumpkinCarvingData(this.pixels, this.type, b);
    }

    public PumpkinCarvingData withPixels(boolean[][] pixels) {
        return new PumpkinCarvingData(pixels, this.type, this.waxed);
    }

    public static long[] pack(boolean[][] pixels) {
        long[] packed = new long[4];
        for (int i = 0; i < 16; ++i) {
            int chunk = i % 4;
            int longIndex = i / 4;
            for (int j = 0; j < 16; ++j) {
                if (!pixels[i][j]) continue;
                int bitInLong = j + chunk * 16;
                int n = longIndex;
                packed[n] = packed[n] | 1L << bitInLong;
            }
        }
        return packed;
    }

    public static boolean[][] unpack(long[] packed) {
        boolean[][] pixels = new boolean[16][16];
        for (int i = 0; i < 16; ++i) {
            int chunk = i % 4;
            int longIndex = i / 4;
            for (int j = 0; j < 16; ++j) {
                int bitInLong = j + chunk * 16;
                pixels[i][j] = (packed[longIndex] & 1L << bitInLong) != 0L;
            }
        }
        return pixels;
    }

    public static long[] unpackPixelsFromStringWhiteOnly(String packed) {
        long[] unpacked = new long[16];
        char[] chars = packed.toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length) {
            long l = 0L;
            char c = chars[i];
            for (int k = 0; k < 4; ++k) {
                l |= (long)((c >> k & 1) << 4 * k);
            }
            char c2 = chars[i + 1];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c2 >> k & 1) << 16 + 4 * k;
            }
            char c3 = chars[i + 2];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c3 >> k & 1) << 32 + 4 * k;
            }
            char c4 = chars[i + 3];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c4 >> k & 1) << 48 + 4 * k;
            }
            unpacked[j] = l;
            ++j;
            i += 4;
        }
        return unpacked;
    }

    public static String packPixelsToStringWhiteOnly(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char c = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 4 * k & 1L);
                c = (char)(c | h << k);
            }
            char c1 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 16 + 4 * k & 1L);
                c1 = (char)(c1 | h << k);
            }
            char c2 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 32 + 4 * k & 1L);
                c2 = (char)(c2 | h << k);
            }
            char c3 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 48 + 4 * k & 1L);
                c3 = (char)(c3 | h << k);
            }
            builder.append(c).append(c1).append(c2).append(c3);
        }
        return builder.toString();
    }

    public PumpkinCarvingData withType(Holder<PumpkinType> pumpkinType) {
        return new PumpkinCarvingData(this.pixels, pumpkinType, this.waxed);
    }
}

