/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.integration.neoforge;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.blocks.RedstoneCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.misc.OptRegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public class AutumnityCompatImpl {
    private static EndergeticCompat ENDERGETIC;
    private static CavesAndChasmCompat CAVERNS_AND_CHASMS;
    private static final Supplier<Block> SOUL_JACK_O_LANTERN_BLOCK;
    private static final Supplier<Block> REDSTONE_JACK_O_LANTERN_BLOCK;
    public static final Supplier<ModCarvedPumpkinBlock> SOUL_JACK_O_LANTERN;
    public static final Supplier<ModCarvedPumpkinBlock> REDSTONE_JACK_O_LANTERN;
    public static final RegSupplier<PumpkinType> SOUL;
    public static final RegSupplier<PumpkinType> REDSTONE;

    public static void init() {
        if (PlatHelper.isModLoaded((String)"endergetic")) {
            ENDERGETIC = new EndergeticCompat();
        }
        if (PlatHelper.isModLoaded((String)"caverns_and_chasms")) {
            CAVERNS_AND_CHASMS = new CavesAndChasmCompat();
        }
        RegHelper.addItemsToTabsRegistration(AutumnityCompatImpl::addItemsToTabs);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
    }

    private static Supplier<Block> block(String name) {
        return OptRegSupplier.of((ResourceLocation)AutumnityCompatImpl.res(name), (Registry)BuiltInRegistries.BLOCK);
    }

    @NotNull
    private static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"autumnity", (String)name);
    }

    static {
        SOUL_JACK_O_LANTERN_BLOCK = AutumnityCompatImpl.block("soul_jack_o_lantern");
        REDSTONE_JACK_O_LANTERN_BLOCK = AutumnityCompatImpl.block("redstone_jack_o_lantern");
        SOUL_JACK_O_LANTERN = ModRegistry.regPumpkin("soul_jack_o_lantern", () -> new ModCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARVED_PUMPKIN).lightLevel(s -> 10), (Holder<PumpkinType>)SOUL));
        REDSTONE_JACK_O_LANTERN = ModRegistry.regPumpkin("redstone_jack_o_lantern", () -> new RedstoneCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARVED_PUMPKIN), (Holder<PumpkinType>)REDSTONE));
        SOUL = PumpkinType.register(AutumnityCompatImpl.res("soul_jack_o_lantern"), () -> Items.SOUL_TORCH, SOUL_JACK_O_LANTERN, SOUL_JACK_O_LANTERN_BLOCK);
        REDSTONE = PumpkinType.register(AutumnityCompatImpl.res("redstone_jack_o_lantern"), () -> Items.REDSTONE_TORCH, REDSTONE_JACK_O_LANTERN, REDSTONE_JACK_O_LANTERN_BLOCK);
    }

    private static class EndergeticCompat {
        private static final Supplier<Block> ENDER_JACK_O_LANTERN_BLOCK = AutumnityCompatImpl.block("ender_jack_o_lantern");
        private final Supplier<Item> enderTorch = Suppliers.memoize(() -> BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)"endergetic:ender_torch")).orElse(null));
        public final Supplier<ModCarvedPumpkinBlock> enderJackOLantern = ModRegistry.regPumpkin("ender_jack_o_lantern", () -> new ModCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARVED_PUMPKIN).lightLevel(s -> 10), (Holder<PumpkinType>)this.ender));
        private final RegSupplier<PumpkinType> ender = PumpkinType.register(AutumnityCompatImpl.res("ender_jack_o_lantern"), this.enderTorch, this.enderJackOLantern, ENDER_JACK_O_LANTERN_BLOCK);

        private EndergeticCompat() {
        }
    }

    private static class CavesAndChasmCompat {
        private static final Supplier<Block> CUPRIC_JACK_O_LANTERN_BLOCK = AutumnityCompatImpl.block("green_jack_o_lantern");
        private final Supplier<Item> greenTorch = Suppliers.memoize(() -> BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)"caverns_and_chasms:cupric_torch")).orElse(null));
        public final Supplier<ModCarvedPumpkinBlock> greenJackOLantern = ModRegistry.regPumpkin("green_jack_o_lantern", () -> new ModCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARVED_PUMPKIN).lightLevel(s -> 10), (Holder<PumpkinType>)this.green));
        private final RegSupplier<PumpkinType> green = PumpkinType.register(AutumnityCompatImpl.res("green_jack_o_lantern"), this.greenTorch, this.greenJackOLantern, CUPRIC_JACK_O_LANTERN_BLOCK);

        private CavesAndChasmCompat() {
        }
    }
}

