/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.integration;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.integration.neoforge.FDCompatImpl;
import net.mehvahdjukaar.hauntedharvest.reg.ModFoods;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTabs;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.BuddingTomatoBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FDCompat {
    private static final Supplier<Block> BUDDING_TOMATO_CROP = FDCompat.obj("farmersdelight:budding_tomatoes", BuiltInRegistries.BLOCK);
    private static final Supplier<Block> TOMATO_CROP = FDCompat.obj("farmersdelight:tomatoes", BuiltInRegistries.BLOCK);
    public static final Supplier<Holder<MobEffect>> NOURISHMENT = FDCompat.holder("farmersdelight:nourishment", BuiltInRegistries.MOB_EFFECT);
    public static final FoodProperties SUCCOTASH_FOOD = FDCompat.makeFood();
    public static final Supplier<Block> CORN_CRATE = ModRegistry.regWithItem("corn_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(2.0f, 3.0f).sound(SoundType.WOOD)), new Item.Properties());
    public static final Supplier<Item> CORNBREAD = ModRegistry.regItem("cornbread", () -> new ConsumableItem(ModItems.foodItem((FoodProperties)ModFoods.CORNBREAD), false));
    public static final Supplier<Item> SUCCOTASH = ModRegistry.regItem("succotash", () -> new ConsumableItem(ModItems.bowlFoodItem((FoodProperties)SUCCOTASH_FOOD), true));

    public static void init() {
        RegHelper.addItemsToTabsRegistration(FDCompat::addItemToTabsEvent);
    }

    public static void addItemToTabsEvent(RegHelper.ItemToTabEvent event) {
        ModTabs.after(event, Items.BREAD, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "corn", CORNBREAD);
        ModTabs.after(event, Items.BEETROOT_SOUP, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "corn", SUCCOTASH);
        ModTabs.add(event, (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "corn", CORN_CRATE);
    }

    public static BlockState getTomato(RandomSource randomSource) {
        int age = randomSource.nextInt(4);
        if (randomSource.nextBoolean()) {
            return (BlockState)BUDDING_TOMATO_CROP.get().defaultBlockState().setValue((Property)BuddingTomatoBlock.AGE, (Comparable)Integer.valueOf(age));
        }
        return (BlockState)TOMATO_CROP.get().defaultBlockState().setValue((Property)TomatoVineBlock.VINE_AGE, (Comparable)Integer.valueOf(age));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FoodProperties makeFood() {
        return FDCompatImpl.makeFood();
    }

    private static <T> Supplier<@Nullable T> obj(String name, Registry<T> registry) {
        return Suppliers.memoize(() -> registry.getOptional(ResourceLocation.parse((String)name)).orElseThrow());
    }

    private static <T> Supplier<@Nullable Holder<T>> holder(String name, Registry<T> registry) {
        return Suppliers.memoize(() -> (Holder)registry.getHolder(ResourceLocation.parse((String)name)).orElseThrow());
    }
}

