/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.screens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.client.screens.CarvingButton;
import net.mehvahdjukaar.hauntedharvest.network.ServerBoundCarvePumpkinPacket;
import net.mehvahdjukaar.moonlight.api.misc.CircularList;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;

public class CarvingScreen
extends Screen {
    private static final MutableComponent UNDO = Component.translatable((String)"gui.hauntedharvest.carving.undo");
    private static final MutableComponent CLEAR = Component.translatable((String)"gui.hauntedharvest.carving.clear");
    private static final MutableComponent EDIT = Component.translatable((String)"gui.hauntedharvest.carving.edit");
    private final ModCarvedPumpkinBlockTile tile;
    private final CarvingButton[][] buttons = new CarvingButton[16][16];
    private final Deque<List<Entry>> history = new CircularList(20);
    private final Direction clickedFace;
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private Button historyButton;

    private CarvingScreen(ModCarvedPumpkinBlockTile teBoard, Direction dir) {
        super((Component)EDIT);
        this.tile = teBoard;
        this.clickedFace = dir;
    }

    public static void open(ModCarvedPumpkinBlockTile tile, Direction dir) {
        Minecraft.getInstance().setScreen((Screen)new CarvingScreen(tile, dir));
    }

    public void recomputeMaterials() {
        Material[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(this.computePixelMatrix(), (PumpkinType)this.tile.getPumpkinType().value());
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setMaterial(materials[xx][yy]);
            }
        }
    }

    private boolean[][] computePixelMatrix() {
        boolean[][] pixels = new boolean[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].carved;
            }
        }
        return pixels;
    }

    public void tick() {
        if (!this.isValid()) {
            this.onClose();
        } else if (!(this.getFocused() instanceof CarvingButton)) {
            this.setFocused(null);
        }
    }

    private boolean isValid() {
        return this.minecraft != null && this.minecraft.player != null && !this.tile.isRemoved() && this.tile.canBeUsedBy(this.tile.getBlockPos(), (Entity)this.minecraft.player);
    }

    public void onClose() {
        this.tile.setChanged();
        super.onClose();
    }

    public void removed() {
        boolean[][] pixels = new boolean[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getCarved();
            }
        }
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundCarvePumpkinPacket(this.tile.getBlockPos(), pixels, this.clickedFace));
    }

    public void updateBlackboard(int x, int y, boolean newColor) {
        this.tile.setPixel(x, y, newColor);
        this.recomputeMaterials();
    }

    public void addHistory(int x, int y, boolean oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.active = true;
        }
    }

    public void onButtonDragged(double mx, double my, boolean buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                CarvingButton b = this.buttons[xx][yy];
                if (!b.isMouseOver(mx, my) || b.getCarved() == buttonValue) continue;
                b.setCarved(buttonValue);
            }
        }
    }

    private void clearPressed(Button button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setCarved(false);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(Button button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setCarved(v.carved);
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.active = false;
        }
    }

    protected void init() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                boolean pixel = this.tile.getPixel(xx, yy);
                CarvingButton widget = new CarvingButton(this, this.width / 2, 65, xx, yy, pixel);
                this.buttons[xx][yy] = (CarvingButton)this.addRenderableWidget(widget);
            }
        }
        this.recomputeMaterials();
        int buttonW = 56;
        int sep = 4;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CLEAR, this::clearPressed).bounds(this.width / 2 - buttonW / 2 - buttonW + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - buttonW / 2 + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
        this.historyButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)UNDO, this::undoPressed).bounds(this.width / 2 + buttonW / 2 + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private record Entry(int x, int y, boolean carved) {
    }
}

