/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.model;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class CarvedPumpkinBakedModel
implements CustomBakedModel {
    private final ModelState modelTransform;
    private final BakedModel back;

    public CarvedPumpkinBakedModel(BakedModel back, ModelState modelTransform) {
        this.back = back;
        this.modelTransform = modelTransform;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.back.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        PumpkinCarvingData key;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.getQuads(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == state.getValue((Property)ModCarvedPumpkinBlock.FACING) && (key = (PumpkinCarvingData)data.get(ModCarvedPumpkinBlockTile.CARVING)) != null) {
            CarvingManager.CarvingVisuals carving = CarvingManager.getInstance(key);
            quads.addAll(carving.getOrCreateModel(side, this::generateQuads));
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(CarvingManager.CarvingVisuals carving, Direction direction) {
        boolean[][] px = carving.getPixels();
        PumpkinType type = carving.getType();
        Material[][] pixels = PumpkinTextureGenerator.computePixelMaterialMap(px, type);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Transformation rotation = this.modelTransform.getRotation();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            Material prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Material current = null;
                if (y < pixels[x].length) {
                    Material b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                TextureAtlasSprite sprite = prevColor.sprite();
                quads.add(CarvedPumpkinBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.0f, 0.0625f, (float)length / 16.0f, sprite, rotation));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    public static BakedQuad createPixelQuad(float x, float y, float z, float width, float height, TextureAtlasSprite sprite, Transformation transform) {
        float u0 = 1.0f - x;
        float v0 = 1.0f - y;
        float u1 = 1.0f - (x + width);
        float v1 = 1.0f - (y + height);
        AtomicReference quad = new AtomicReference();
        try (BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite, (Transformation)transform, quad::set);){
            builder.setAutoDirection();
            CarvedPumpkinBakedModel.putVertex(builder, x + width, y + height, z, u1, v1);
            CarvedPumpkinBakedModel.putVertex(builder, x + width, y, z, u1, v0);
            CarvedPumpkinBakedModel.putVertex(builder, x, y, z, u0, v0);
            CarvedPumpkinBakedModel.putVertex(builder, x, y + height, z, u0, v1);
        }
        catch (Exception e) {
            HauntedHarvest.LOGGER.error("Error creating quad", (Throwable)e);
        }
        return (BakedQuad)quad.get();
    }

    private static void putVertex(BakedQuadBuilder builder, float x, float y, float z, float u, float v) {
        Vector3f posV = new Vector3f(x, y, z);
        posV.set((float)Math.round(posV.x() * 16.0f) / 16.0f, (float)Math.round(posV.y() * 16.0f) / 16.0f, (float)Math.round(posV.z() * 16.0f) / 16.0f);
        builder.addVertex(posV.x, posV.y, posV.z);
        builder.setColor(-1);
        builder.setUv(u / 16.0f, v / 16.0f);
        builder.setNormal(0.0f, 0.0f, -1.0f);
    }
}

