/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class PumpkinTextureGenerator {
    private static DynamicTexture dummy = null;
    private static ResourceLocation dummyLocation = null;

    public static void drawCarving(DynamicTexture texture, CarvingManager.CarvingVisuals carving) {
        boolean[][] pixels = carving.getPixels();
        Material[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(pixels, carving.getType());
        for (int y = 0; y < pixels.length && y < 16; ++y) {
            for (int x = 0; x < pixels[y].length && x < 16; ++x) {
                int c = ClientHelper.getPixelRGBA((TextureAtlasSprite)materials[x][y].sprite(), (int)0, (int)x, (int)y);
                texture.getPixels().setPixelRGBA(x, y, c);
            }
        }
        texture.upload();
    }

    public static Material[][] computePixelMaterialMap(boolean[][] pixels, PumpkinType pumpkinType) {
        PixelType[][] colors = new PixelType[16][16];
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> {
            colors[j.intValue()][i.intValue()] = !pixels[j][i] ? PixelType.UNCARVED : (PumpkinTextureGenerator.shouldShade(colors, j, i) ? PixelType.SHADE : PixelType.BACKGROUND);
        });
        PumpkinTextureGenerator.addExtraShade(colors);
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> PumpkinTextureGenerator.addHighlight(colors, j, i));
        Object[][] materials = new Material[16][16];
        PumpkinTextureGenerator.forEachPixel(materials, (arg_0, arg_1) -> PumpkinTextureGenerator.lambda$computePixelMaterialMap$2((Material[][])materials, pumpkinType, colors, arg_0, arg_1));
        return materials;
    }

    private static void addExtraShade(PixelType[][] px) {
        ArrayList shades = new ArrayList();
        PumpkinTextureGenerator.forEachPixel((Object[][])px, (j, i) -> {
            if (!PumpkinTextureGenerator.isUnCarved(px, j, i) && PumpkinTextureGenerator.isShaded(px, j, i - 1)) {
                if (PumpkinTextureGenerator.isShaded(px, j - 1, i) && PumpkinTextureGenerator.isShaded(px, j + 1, i) && (PumpkinTextureGenerator.isShaded(px, j - 1, i + 1) || PumpkinTextureGenerator.isShaded(px, j + 1, i + 1))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
                if (PumpkinTextureGenerator.isShaded(px, j, i + 1) && (PumpkinTextureGenerator.isShaded(px, j + 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j - 1, i) || PumpkinTextureGenerator.isShaded(px, j - 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j + 1, i))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
            }
        });
        shades.forEach(p -> {
            px[((Integer)p.getFirst()).intValue()][((Integer)p.getSecond()).intValue()] = PixelType.SHADE;
        });
    }

    private static void addHighlight(PixelType[][] px, int j, int i) {
        if (!(!PumpkinTextureGenerator.isUnCarved(px, j, i) || PumpkinTextureGenerator.isUnCarved(px, j - 1, i) && PumpkinTextureGenerator.isUnCarved(px, j, i - 1))) {
            px[j][i] = PixelType.HIGHLIGHT;
        }
    }

    private static boolean shouldShade(PixelType[][] px, int j, int i) {
        return PumpkinTextureGenerator.isUnCarved(px, j - 1, i) || PumpkinTextureGenerator.isUnCarved(px, j, i - 1);
    }

    private static boolean isUnCarved(PixelType[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        PixelType t = px[j][i];
        return t == PixelType.UNCARVED || t == PixelType.HIGHLIGHT;
    }

    private static boolean isShaded(PixelType[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        return px[j][i] == PixelType.SHADE;
    }

    public static void forEachPixel(Object[][] px, BiConsumer<Integer, Integer> function) {
        for (int j = 0; j < px.length; ++j) {
            for (int i = 0; i < px[j].length; ++i) {
                function.accept(j, i);
            }
        }
    }

    public static void drawBlur(FrameBufferBackedDynamicTexture t, CarvingManager.CarvingVisuals carving) {
        boolean[][] pixels = carving.getPixels();
        if (dummyLocation == null) {
            dummy = new DynamicTexture(18, 18, false);
            dummyLocation = Minecraft.getInstance().getTextureManager().register("carving/", dummy);
        }
        NativeImage p = dummy.getPixels();
        SpriteUtils.forEachPixel((NativeImage)p, (T x, U y) -> {
            int alpha = 0;
            if (x == 0 || x == 17 || y == 0 || y == 17 || !pixels[x - 1][y - 1]) {
                alpha = 255;
            }
            p.setPixelRGBA(x.intValue(), y.intValue(), FastColor.ABGR32.color((int)alpha, (int)0, (int)0, (int)0));
        });
        dummy.upload();
        dummy.setFilter(true, false);
        RenderedTexturesManager.drawAsInGUI((FrameBufferBackedDynamicTexture)t, s -> {
            float u0 = 0.055555556f;
            float u1 = 0.9444444f;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)dummyLocation);
            PoseStack.Pose matrix = s.pose().last();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableBlend();
            RenderSystem.setShader(ClientRegistry::getBlur);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix, 0.0f, 16.0f, 0.0f).setUv(u0, u0);
            bufferBuilder.addVertex(matrix, 16.0f, 16.0f, 0.0f).setUv(u1, u0);
            bufferBuilder.addVertex(matrix, 16.0f, 0.0f, 0.0f).setUv(u1, u1);
            bufferBuilder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(u0, u1);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
        });
        t.setFilter(true, false);
    }

    private static /* synthetic */ void lambda$computePixelMaterialMap$2(Material[][] materials, PumpkinType pumpkinType, PixelType[][] colors, Integer j, Integer i) {
        materials[j.intValue()][i.intValue()] = ClientRegistry.getMaterial(pumpkinType, colors[j][i].ordinal());
    }

    private static enum PixelType {
        UNCARVED,
        SHADE,
        BACKGROUND,
        HIGHLIGHT;

    }
}

