/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.client.model.HalloweenMaskModel;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;

public class HalloweenMaskLayer<T extends Villager, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{HauntedHarvest.res("textures/entity/villager/masks/pumpkin.png"), HauntedHarvest.res("textures/entity/villager/masks/zombie.png"), HauntedHarvest.res("textures/entity/villager/masks/skeleton.png"), HauntedHarvest.res("textures/entity/villager/masks/spider.png"), HauntedHarvest.res("textures/entity/villager/masks/enderman.png"), HauntedHarvest.res("textures/entity/villager/masks/creeper.png"), HauntedHarvest.res("textures/entity/villager/masks/vindicator.png"), HauntedHarvest.res("textures/entity/villager/masks/piglin.png"), HauntedHarvest.res("textures/entity/villager/masks/paper_bag.png")};
    private final HalloweenMaskModel<T> headModel;

    public HalloweenMaskLayer(RenderLayerParent<T, M> parent, EntityRendererProvider.Context context) {
        super(parent);
        this.headModel = new HalloweenMaskModel(context.bakeLayer(ModelLayers.VILLAGER));
    }

    protected ResourceLocation getTextureLocation(T entity) {
        return TEXTURES[(int)Math.abs(entity.getUUID().getLeastSignificantBits() % (long)(CommonConfigs.PAPER_BAG.get() != false ? 9 : 8))];
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.isBaby() && HauntedHarvest.isTrickOrTreatTime(pLivingEntity.level())) {
            this.headModel.prepareMobModel((Entity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
            this.getParentModel().copyPropertiesTo(this.headModel);
            this.headModel.getHead().copyFrom(((HeadedModel)this.getParentModel()).getHead());
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(pLivingEntity)));
            this.headModel.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            this.headModel.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition m = VillagerModel.createBodyModel();
        return LayerDefinition.create((MeshDefinition)m, (int)64, (int)64);
    }
}

