/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;

public class CarvedPumpkinTileRenderer
implements BlockEntityRenderer<ModCarvedPumpkinBlockTile> {
    private static final int WIDTH = 6;

    public CarvedPumpkinTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public int getViewDistance() {
        return 8;
    }

    public boolean shouldRender(ModCarvedPumpkinBlockTile blockEntity, Vec3 cameraPos) {
        return super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(ModCarvedPumpkinBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        LocalPlayer player;
        BlockHitResult blockHit;
        if (!tile.getCarveMode().canManualDraw()) {
            return;
        }
        Direction dir = tile.getDirection();
        Minecraft mc = Minecraft.getInstance();
        LOD lod = LOD.at((BlockEntity)tile);
        BlockPos pos = tile.getBlockPos();
        if (lod.isPlaneCulled(dir, 0.375f)) {
            return;
        }
        HitResult hit = mc.hitResult;
        if (hit != null && hit.getType() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).getBlockPos().equals((Object)pos) && tile.getDirection() == blockHit.getDirection() && (player = mc.player) != null && tile.getLevel() != null && ModCarvedPumpkinBlock.isCarverItem(player.getMainHandItem())) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.mulPose(RotHlpr.rot((Direction)dir));
            matrixStackIn.mulPose(RotHlpr.XN90);
            matrixStackIn.translate(-0.5, -0.5, 0.5);
            int frontLight = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)pos.relative(dir));
            int lu = frontLight & 0xFFFF;
            int lv = frontLight >> 16 & 0xFFFF;
            Vector2i pair = ModCarvedPumpkinBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)pair.x() * p;
            float y = (float)pair.y() * p;
            VertexConsumer builder2 = ClientRegistry.CARVING_OUTLINE.buffer(bufferIn, RenderType::entityCutout);
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)x, (double)(1.0f - y - p), 0.001);
            VertexUtil.addQuad((VertexConsumer)builder2, (PoseStack)matrixStackIn, (float)0.0f, (float)0.0f, (float)p, (float)p, (int)lu, (int)lv);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }
}

