/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class PumpkinType {
    public static final Registry<PumpkinType> REGISTRY = RegHelper.registerRegistry((ResourceLocation)HauntedHarvest.res("pumpkin_type"), (boolean)true);
    private static final Map<Item, PumpkinType> TORCH_MAP = new Object2ObjectOpenHashMap();
    public static final RegSupplier<PumpkinType> NORMAL = PumpkinType.register(HauntedHarvest.res("carved_pumpkin"), () -> null, ModRegistry.CARVED_PUMPKIN, () -> Blocks.CARVED_PUMPKIN);
    public static final RegSupplier<PumpkinType> JACK = PumpkinType.register(HauntedHarvest.res("jack_o_lantern"), () -> Items.TORCH, ModRegistry.JACK_O_LANTERN, () -> Blocks.JACK_O_LANTERN);
    private final String textureKey;
    private final Supplier<? extends Item> torch;
    private final Supplier<? extends ModCarvedPumpkinBlock> pumpkin;
    private final Supplier<? extends Block> vanillaPumpkin;

    public PumpkinType(String textureKey, Supplier<? extends Item> torch, Supplier<? extends ModCarvedPumpkinBlock> pumpkin, Supplier<? extends Block> vanillaPumpkin) {
        this.torch = torch;
        this.pumpkin = pumpkin;
        this.vanillaPumpkin = vanillaPumpkin;
        this.textureKey = textureKey;
    }

    public static Holder<PumpkinType> fromPumpkinItem(Item item) {
        BlockItem bi;
        Block block;
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).getBlock()) instanceof ModCarvedPumpkinBlock) {
            ModCarvedPumpkinBlock block2 = (ModCarvedPumpkinBlock)block;
            return block2.getType(block2.defaultBlockState());
        }
        throw new IllegalArgumentException("Item is not a pumpkin");
    }

    public Item getTorch() {
        return this.torch.get();
    }

    public Block getPumpkin() {
        return (Block)this.pumpkin.get();
    }

    public Block getVanillaPumpkin() {
        return this.vanillaPumpkin.get();
    }

    public String getTextureKey() {
        return this.textureKey;
    }

    public final boolean isJackOLantern() {
        return this != NORMAL.get();
    }

    @Nullable
    public static PumpkinType getFromTorch(Item torch) {
        return TORCH_MAP.get(torch);
    }

    public static void init() {
    }

    public static void setup() {
        for (PumpkinType pumpkinType : REGISTRY) {
            TORCH_MAP.put(pumpkinType.getTorch(), pumpkinType);
        }
    }

    public static RegSupplier<PumpkinType> register(ResourceLocation name, Supplier<? extends Item> torch, Supplier<? extends ModCarvedPumpkinBlock> pumpkin, Supplier<? extends Block> vanillaPumpkin) {
        String textureKey = name.getNamespace().equals("hauntedharvest") ? name.getPath() : name.getNamespace() + "/" + name.getPath();
        return RegHelper.register((ResourceLocation)name, () -> new PumpkinType(textureKey, torch, pumpkin, vanillaPumpkin), (ResourceKey)REGISTRY.key());
    }
}

