/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyBagTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PaperBagBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CandyBagBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Content> CONTENT = EnumProperty.create((String)"content", Content.class);
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.create((String)"fill_level", (int)1, (int)6);
    private static final int POPCORN_COOK_TIME = 200;

    public CandyBagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(CONTENT, (Comparable)((Object)Content.POPCORN))).setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public static boolean tryFilling(Player player, Level level, BlockPos pos, ItemStack stack) {
        Content content = Content.get(stack);
        if (content != null) {
            BlockEntity blockEntity;
            ItemStack remove = player.isCreative() ? stack.copy() : stack.split(1);
            remove.setCount(1);
            BlockState state = (BlockState)ModRegistry.CANDY_BAG.get().defaultBlockState().setValue(CONTENT, (Comparable)((Object)content));
            level.setBlockAndUpdate(pos, state);
            CandyBagBlock.playSound(level, pos);
            CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
            if (content == Content.OTHER_CANDY && (blockEntity = level.getBlockEntity(pos)) instanceof CandyBagTile) {
                CandyBagTile tile = (CandyBagTile)blockEntity;
                tile.setDisplayedItem(remove);
            }
            return true;
        }
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PaperBagBlock.SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONTENT, FILL_LEVEL});
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Item i;
        List list = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)((Object)object);
            list.add(tile.getDisplayedItem().copy());
        }
        if ((i = this.getContent(state)) != null) {
            list.add(new ItemStack((ItemLike)i, ((Integer)state.getValue((Property)FILL_LEVEL)).intValue()));
        }
        return list;
    }

    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack item;
        int fill = (Integer)state.getValue((Property)FILL_LEVEL);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)blockEntity;
            item = tile.getDisplayedItem();
            if (item.isEmpty()) {
                item = null;
            }
        } else {
            item = new ItemStack((ItemLike)this.getContent(state), fill);
        }
        if (item == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int delta = 0;
        if (player.isShiftKeyDown() && held.isEmpty()) {
            ItemStack extracted = item.copy().split(1);
            if (!extracted.isEmpty()) {
                Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)extracted);
                delta = -1;
            }
        } else if (fill != 6 && Content.get(held) == state.getValue(CONTENT)) {
            if (!player.isCreative()) {
                held.shrink(1);
            }
            CandyBagBlock.playSound(level, pos);
            ++delta;
        } else if (item.has(DataComponents.FOOD) && player.canEat(false) && !player.isCreative()) {
            player.eat(level, item.copy());
            delta = -1;
            if (level.isClientSide) {
                ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.ITEM, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.2;
                for (int i = 0; i < 12; ++i) {
                    level.addParticle((ParticleOptions)particleOptions, (double)((float)pos.getX() + 0.125f + level.random.nextFloat() * 12.0f / 16.0f), (double)pos.getY() + dy, (double)((float)pos.getZ() + 0.125f + level.random.nextFloat() * 12.0f / 16.0f), ((double)level.random.nextFloat() - 0.5) * power, (double)level.random.nextFloat() * power * 0.7, ((double)level.random.nextFloat() - 0.5) * power);
                }
            }
        }
        if (delta != 0) {
            int newFill = fill + delta;
            if (newFill == 0) {
                level.setBlockAndUpdate(pos, ModRegistry.PAPER_BAG.get().defaultBlockState());
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(newFill)));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void playSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.PLAYERS, 1.0f, 1.2f);
    }

    @Nullable
    public Item getContent(BlockState state) {
        Optional i;
        Content c = (Content)((Object)state.getValue(CONTENT));
        if (c.drop != null && (i = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)c.drop))).isPresent()) {
            return (Item)i.get();
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbor, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, neighbor, fromPos, isMoving);
        if (state.getValue(CONTENT) == Content.KERNELS && CandyBagBlock.canCook(level.getBlockState(fromPos))) {
            level.scheduleTick(pos, (Block)this, 200);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean canPop;
        if (state.getValue(CONTENT) == Content.KERNELS && (canPop = Arrays.stream(Direction.values()).anyMatch(d -> CandyBagBlock.canCook(level.getBlockState(pos.relative(d)))))) {
            this.popCorn(state, level, pos);
            level.scheduleTick(pos, (Block)this, 3);
        }
    }

    private static void schedulePopTickIfPossible(BlockState state, Level level, BlockPos pos) {
        boolean canPop = Arrays.stream(Direction.values()).anyMatch(d -> CandyBagBlock.canCook(level.getBlockState(pos.relative(d))));
        if (canPop) {
            level.scheduleTick(pos, state.getBlock(), 200);
        }
    }

    private void popCorn(BlockState state, ServerLevel level, BlockPos pos) {
        int fill = (Integer)state.getValue((Property)FILL_LEVEL);
        ItemStack item = new ItemStack((ItemLike)ModRegistry.POP_CORN.get());
        level.blockEvent(pos, (Block)this, 1, 0);
        if (fill == 1) {
            level.setBlockAndUpdate(pos, ModRegistry.PAPER_BAG.get().defaultBlockState());
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(fill - 1)));
        }
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, item);
        itemEntity.setDeltaMovement(level.random.nextDouble() * 0.02, 0.08 + level.random.nextDouble() * 0.2, level.random.nextDouble() * 0.02);
        level.addFreshEntity((Entity)itemEntity);
        level.playSound(null, pos, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.BLOCKS, 0.2f, 2.0f);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.isClientSide) {
                int fill = (Integer)state.getValue((Property)FILL_LEVEL);
                ItemStack item = new ItemStack((ItemLike)ModRegistry.POP_CORN.get());
                ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.ITEM, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.3;
                for (int i = 0; i < 7; ++i) {
                    level.addParticle((ParticleOptions)particleOptions, (double)pos.getX() + 0.5, (double)pos.getY() + dy, (double)pos.getZ() + 0.5, ((double)level.random.nextFloat() - 0.5) * power, (double)level.random.nextFloat() * power + 0.2, ((double)level.random.nextFloat() - 0.5) * power);
                }
            }
            return true;
        }
        return super.triggerEvent(state, level, pos, id, param);
    }

    private static boolean canCook(BlockState neighbor) {
        return neighbor.is(BlockTags.CAMPFIRES) && (Boolean)neighbor.getValue((Property)CampfireBlock.LIT) != false || neighbor.getBlock() instanceof FireBlock;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(CONTENT) == Content.OTHER_CANDY ? new CandyBagTile(pos, state) : null;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ModRegistry.PAPER_BAG.get().asItem().getDefaultInstance();
    }

    public static enum Content implements StringRepresentable
    {
        CANDY("supplementaries:candy"),
        CANDY_CANE("snowyspirit:candy_cane"),
        CANDY_CORN("hauntedharvest:candy_corn"),
        POPCORN("hauntedharvest:popcorn"),
        KERNELS("hauntedharvest:kernels"),
        OTHER_CANDY(null);

        private final String drop;

        private Content(String drop) {
            this.drop = drop;
        }

        @Nullable
        public static Content get(ItemStack item) {
            if (item.isEmpty()) {
                return null;
            }
            String name = Utils.getID((Item)item.getItem()).toString();
            for (Content c : Content.values()) {
                if (c.drop == null || !c.drop.equals(name)) continue;
                return c;
            }
            if (item.is(ModTags.MODDED_CANDIES)) {
                return OTHER_CANDY;
            }
            return null;
        }

        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

