/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.IHarmlessProjectile;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ThrowEggs
extends Behavior<Villager> {
    private int cooldownBetweenAttacks;
    private int eggs;
    private final int maxRange;
    private int duration = 400;

    public ThrowEggs(int range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT));
        this.maxRange = range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity livingentity = this.getAttackTarget((LivingEntity)pOwner);
        if (livingentity == null || !livingentity.isAlive()) {
            ThrowEggs.clearAnger(pOwner);
            return false;
        }
        return BehaviorUtils.canSee((LivingEntity)pOwner, (LivingEntity)livingentity) && livingentity.distanceToSqr(pOwner.getX(), pOwner.getY(), pOwner.getZ()) < (double)(this.maxRange * this.maxRange);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.eggs == 0 || this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget((LivingEntity)pEntity);
        BehaviorUtils.lookAtEntity((LivingEntity)pEntity, (LivingEntity)livingentity);
        ThrowEggs.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.EGG));
        if (this.eggs == 0) {
            this.duration = 400;
            this.eggs = pLevel.random.nextInt(2) + 1;
            this.cooldownBetweenAttacks = 35 + pLevel.random.nextInt(30);
        }
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.getAttackTarget((LivingEntity)pOwner);
        if (target == null) {
            return;
        }
        BehaviorUtils.lookAtEntity((LivingEntity)pOwner, (LivingEntity)target);
        if (this.cooldownBetweenAttacks-- == 0) {
            this.cooldownBetweenAttacks = 20 + pLevel.random.nextInt(30);
            --this.eggs;
            ThrownEgg egg = new ThrownEgg((Level)pLevel, (LivingEntity)pOwner);
            if (egg instanceof IHarmlessProjectile) {
                IHarmlessProjectile e = (IHarmlessProjectile)egg;
                e.hauntedharvest$setHarmless(true);
            }
            double d0 = target.getY() - 0.5;
            double d1 = target.getX() - pOwner.getX();
            double d2 = d0 - egg.getY();
            double d3 = target.getZ() - pOwner.getZ();
            double distFactor = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            egg.shoot(d1, (d2 + distFactor) * 0.5, d3, 1.1f, 8.0f);
            pLevel.playSound(null, pOwner.getX(), pOwner.getY(), pOwner.getZ(), SoundEvents.EGG_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            pLevel.addFreshEntity((Entity)egg);
            if (this.eggs <= 0) {
                ThrowEggs.clearAnger(pOwner);
            }
        }
        if (this.duration-- <= 0) {
            ThrowEggs.clearAnger(pOwner);
        }
    }

    public static void clearAnger(Villager pOwner) {
        pOwner.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        ThrowEggs.displayAsHeldItem(pOwner, ItemStack.EMPTY);
    }

    private static void displayAsHeldItem(Villager self, ItemStack p_182372_) {
        self.setItemSlot(EquipmentSlot.MAINHAND, p_182372_);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
    }

    @Nullable
    private LivingEntity getAttackTarget(LivingEntity pMob) {
        return pMob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }
}

