/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class RemovePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 600;
    protected int lastBreakProgress = -1;

    public RemovePumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 270, 350);
        this.speedModifier = speed * 1.1f;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get();
        return globalpos.dimension() == pLevel.dimension() && !pOwner.isBaby();
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (5 + pLevel.random.nextInt(20)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get();
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(globalpos.pos(), this.speedModifier, 1));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.IRON_AXE));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.getBrain().hasMemoryValue(ModRegistry.PUMPKIN_POS.get());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get()).pos();
        pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(pos));
        if (pos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = pLevel.getBlockState(pos);
            if (!state.is(ModTags.PUMPKINS)) {
                pOwner.getBrain().eraseMemory(ModRegistry.PUMPKIN_POS.get());
            } else {
                int k = (int)((float)this.ticksSinceReached / 20.0f * 10.0f);
                if (k != this.lastBreakProgress) {
                    pLevel.destroyBlockProgress(pOwner.getId(), pos, k);
                    this.lastBreakProgress = k;
                }
                if (this.ticksSinceReached > 20) {
                    SoundType soundtype = state.getSoundType();
                    pLevel.playSound(null, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    pOwner.getBrain().eraseMemory(ModRegistry.PUMPKIN_POS.get());
                    pLevel.destroyBlock(pos, true);
                }
            }
        }
    }
}

