/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class PlacePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private BlockPos targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public PlacePumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.isBaby()) {
            return false;
        }
        if (pLevel.random.nextInt(2) == 0) {
            this.cooldown = 400;
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (15 + pLevel.random.nextInt(10)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePumpkin.getValidPumpkinPos(pLevel, (LivingEntity)pEntity);
        if (this.targetPos != null) {
            pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, this.speedModifier, 1));
            AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.PUMPKIN));
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.targetPos != null && PlacePumpkin.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, this.speedModifier, 2));
            pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            if (this.targetPos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    BlockState state = Blocks.PUMPKIN.defaultBlockState();
                    pLevel.setBlockAndUpdate(this.targetPos, state);
                    SoundType soundtype = state.getSoundType();
                    pLevel.playSound(null, this.targetPos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    pOwner.getBrain().setMemory(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.of((ResourceKey)pLevel.dimension(), (BlockPos)this.targetPos));
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static BlockPos getValidPumpkinPos(ServerLevel pLevel, LivingEntity pWalker) {
        RandomSource random = pWalker.getRandom();
        BlockPos blockpos = pWalker.blockPosition();
        for (int i = 0; i < 6; ++i) {
            BlockPos pos = blockpos.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!PlacePumpkin.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(ServerLevel serverLevel, BlockPos pos) {
        BlockState state;
        if (serverLevel.canSeeSky(pos) && (double)serverLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() >= 64.0 && (state = serverLevel.getBlockState(pos)).canBeReplaced() && state.getFluidState().isEmpty()) {
            BlockState below = serverLevel.getBlockState(pos.below());
            return below.is(ModTags.PUMPKIN_SUPPORT);
        }
        return false;
    }
}

