/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightUpPumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 100;
    protected int lastBreakProgress = -1;

    public LightUpPumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT, ModRegistry.PUMPKIN_POS.get(), (Object)MemoryStatus.VALUE_PRESENT), 250, 360);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isTrickOrTreatTime((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get();
        return globalpos.dimension() == pLevel.dimension() && pOwner.isBaby() && globalpos.pos().closerToCenterThan((Position)pOwner.position(), 28.0);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (20 + pLevel.random.nextInt(20)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get();
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(globalpos.pos(), this.speedModifier, 1));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.TORCH));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.getBrain().hasMemoryValue(ModRegistry.PUMPKIN_POS.get());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.getBrain().getMemory(ModRegistry.PUMPKIN_POS.get()).get()).pos();
        pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(pos));
        if (pos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = pLevel.getBlockState(pos);
            if (!state.is(ModTags.CARVED_PUMPKINS)) {
                pOwner.getBrain().eraseMemory(ModRegistry.PUMPKIN_POS.get());
            } else if (this.ticksSinceReached > 40) {
                SoundType soundtype = Blocks.TORCH.defaultBlockState().getSoundType();
                pLevel.playSound(null, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                pOwner.getBrain().eraseMemory(ModRegistry.PUMPKIN_POS.get());
                BlockEntity be = pLevel.getBlockEntity(pos);
                Block toPlace = state.is((Block)ModRegistry.CARVED_PUMPKIN.get()) ? (Block)ModRegistry.JACK_O_LANTERN.get() : Blocks.JACK_O_LANTERN;
                pLevel.setBlockAndUpdate(pos, (BlockState)toPlace.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)((Direction)state.getValue((Property)CarvedPumpkinBlock.FACING))));
                if (be instanceof ModCarvedPumpkinBlockTile) {
                    ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)be;
                    BlockEntity blockEntity = pLevel.getBlockEntity(pos);
                    if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                        ModCarvedPumpkinBlockTile newTile = (ModCarvedPumpkinBlockTile)blockEntity;
                        newTile.setPixels(tile.clonePixels());
                    }
                }
            }
        }
    }
}

