/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import java.util.EnumSet;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.GiveCandyToBabies;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GiveCandyWitchGoal
extends Goal {
    protected final int randomInterval;
    protected final Mob witch;
    protected Villager target;
    private boolean hasGivenCandy = false;
    private int tickSinceStarted = 0;
    private int timeToGiveCandy = 0;

    public GiveCandyWitchGoal(Mob pMob) {
        this.randomInterval = 5;
        this.witch = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!HauntedHarvest.isTrickOrTreatTime(this.witch.level())) {
            return false;
        }
        if (this.randomInterval > 0 && this.witch.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.witch.getBoundingBox().inflate(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        this.target = this.witch.level().getEntitiesOfClass(Villager.class, this.getTargetSearchArea(4.0), this::isValidTarget).stream().findAny().orElse(null);
    }

    private boolean isValidTarget(Villager target) {
        return GiveCandyToBabies.isValidTrickOrTreater((LivingEntity)this.witch, (LivingEntity)target);
    }

    public void start() {
        this.witch.lookAt((Entity)this.target, 45.0f, 80.0f);
        super.start();
        this.timeToGiveCandy = 20 + this.witch.level().random.nextInt(30);
        this.tickSinceStarted = 0;
        this.hasGivenCandy = false;
    }

    public void stop() {
        super.stop();
        this.hasGivenCandy = false;
        this.tickSinceStarted = 0;
    }

    public boolean canContinueToUse() {
        if (this.tickSinceStarted < 300 && !this.hasGivenCandy) {
            return this.target != null && this.target.isAlive() && this.isValidTarget(this.target) && this.witch.getSensing().hasLineOfSight((Entity)this.target);
        }
        return false;
    }

    public void tick() {
        this.witch.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        if (this.target != null && this.tickSinceStarted > this.timeToGiveCandy) {
            Level level = this.witch.level();
            int r = level.getRandom().nextInt(12);
            if (r == 0) {
                stack = new ItemStack((ItemLike)ModRegistry.GRIM_APPLE.get());
                GiveCandyToBabies.throwCandy((LivingEntity)this.witch, (LivingEntity)this.target, stack);
                level.broadcastEntityEvent((Entity)this.witch, (byte)15);
            } else if (r < 5) {
                GiveCandyToBabies.spookVillager(this.target, (LivingEntity)this.witch);
                level.broadcastEntityEvent((Entity)this.witch, (byte)15);
            } else {
                stack = new ItemStack((ItemLike)ModRegistry.ROTTEN_APPLE.get());
                GiveCandyToBabies.throwCandy((LivingEntity)this.witch, (LivingEntity)this.target, stack);
            }
            this.hasGivenCandy = true;
            Villager villager = this.target;
            if (villager instanceof IHalloweenVillager) {
                IHalloweenVillager e = (IHalloweenVillager)villager;
                e.hauntedharvest$setEntityOnCooldown((Entity)this.witch, 140);
            }
        }
        ++this.tickSinceStarted;
    }
}

