/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GiveCandyToBabies
extends Behavior<Villager> {
    private boolean hasGivenCandy = false;
    private int tickSinceStarted = 0;
    private int timeToGiveCandy = 0;

    public GiveCandyToBabies() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isTrickOrTreatTime((Level)pLevel)) {
            return false;
        }
        return this.getValidTarget((LivingEntity)pOwner) != null;
    }

    public static boolean isValidTrickOrTreater(LivingEntity self, LivingEntity villagerTarget) {
        IHalloweenVillager e;
        if (!HalloweenVillagerAI.isTrickOrTreater(villagerTarget)) {
            return false;
        }
        if (!(!(self.distanceToSqr((Entity)villagerTarget) <= 12.0) || villagerTarget instanceof IHalloweenVillager && (e = (IHalloweenVillager)villagerTarget).hauntedharvest$isEntityOnCooldown((Entity)self))) {
            Entity lookTarget = villagerTarget.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).orElse(null);
            return lookTarget == self;
        }
        return false;
    }

    @Nullable
    private LivingEntity getValidTarget(LivingEntity self) {
        List list = self.getBrain().getMemory(MemoryModuleType.VISIBLE_VILLAGER_BABIES).orElse(List.of());
        return list.stream().filter(t -> GiveCandyToBabies.isValidTrickOrTreater(self, t)).findFirst().orElse(null);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (this.tickSinceStarted < 300 && !this.hasGivenCandy) {
            Optional p = pEntity.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET);
            return p.isPresent() && GiveCandyToBabies.isValidTrickOrTreater((LivingEntity)pEntity, (LivingEntity)p.get());
        }
        return false;
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.lookAtTarget(pOwner);
        if (target != null && this.tickSinceStarted > this.timeToGiveCandy) {
            int r = pLevel.getRandom().nextInt(12);
            if (r == 0) {
                stack = new ItemStack((ItemLike)Items.CHARCOAL);
                ItemEntity entity = GiveCandyToBabies.throwCandy((LivingEntity)pOwner, target, stack);
                HHPlatformStuff.setItemLifespan(entity, 1200);
                pLevel.broadcastEntityEvent((Entity)pOwner, (byte)13);
            } else if (r < 3) {
                GiveCandyToBabies.spookVillager(pOwner, target);
            } else {
                stack = ((Item)((Holder)((HolderSet.Named)BuiltInRegistries.ITEM.getTag(ModTags.VILLAGER_SWEETS).get()).getRandomElement(pLevel.random).get()).value()).getDefaultInstance();
                GiveCandyToBabies.throwCandy((LivingEntity)pOwner, target, stack);
                pLevel.broadcastEntityEvent((Entity)pOwner, (byte)14);
            }
            this.hasGivenCandy = true;
            if (target instanceof IHalloweenVillager) {
                IHalloweenVillager e = (IHalloweenVillager)target;
                e.hauntedharvest$setEntityOnCooldown((Entity)pOwner);
            }
        }
        ++this.tickSinceStarted;
    }

    public static void spookVillager(Villager target, LivingEntity cause) {
        Level level = target.level();
        ((ServerLevel)level).sendParticles((ParticleOptions)ModRegistry.SPOOKED_PARTICLE.get(), target.getX(), target.getY() + 1.25, target.getZ(), 5, (double)(target.getBbWidth() / 2.0f), (double)(target.getBbHeight() / 3.0f), (double)(target.getBbWidth() / 2.0f), 0.02);
        DamageSource dmg = level.damageSources().generic();
        target.setLastHurtByMob(cause);
        target.hurt(dmg, 0.1f);
        target.heal(0.1f);
        target.getBrain().setActiveActivityIfPossible(Activity.PANIC);
        target.getBrain().setMemory(MemoryModuleType.HURT_BY, (Object)dmg);
        target.getBrain().setMemory(MemoryModuleType.HURT_BY_ENTITY, (Object)cause);
    }

    public static ItemEntity throwCandy(LivingEntity self, LivingEntity pTarget, ItemStack stack) {
        Vec3 vec3 = pTarget.getDeltaMovement();
        double pX = pTarget.getX() + vec3.x - self.getX();
        double d1 = pTarget.getEyeY() - (double)1.1f - self.getY();
        double pZ = pTarget.getZ() + vec3.z - self.getZ();
        double d3 = Math.sqrt(pX * pX + pZ * pZ);
        double d0 = self.getEyeY() - (double)0.3f;
        Level level = self.level();
        ItemEntity itementity = new ItemEntity(level, self.getX(), d0, self.getZ(), stack);
        double pVelocity = 0.179 + d3 * 0.022;
        double pY = d1 + d3 * 0.7;
        itementity.setDeltaMovement(new Vec3(pX, pY, pZ).normalize().scale(pVelocity));
        level.addFreshEntity((Entity)itementity);
        return itementity;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.start(pLevel, (LivingEntity)pEntity, pGameTime);
        pEntity.stopSleeping();
        LivingEntity target = this.lookAtTarget(pEntity);
        this.timeToGiveCandy = 20 + pLevel.random.nextInt(30);
        this.tickSinceStarted = 0;
        this.hasGivenCandy = false;
    }

    @Nullable
    private LivingEntity lookAtTarget(Villager self) {
        LivingEntity entity = this.getValidTarget((LivingEntity)self);
        if (entity != null) {
            Brain brain = self.getBrain();
            brain.setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)entity);
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)entity, true));
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        }
        return entity;
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        Brain brain = pEntity.getBrain();
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
        brain.eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        this.hasGivenCandy = false;
        this.tickSinceStarted = 0;
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
    }
}

