/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EatCandy
extends Behavior<Villager> {
    private int eatingTime;
    private int cooldown = 0;

    public EatCandy(int minDur, int maxDur) {
        super(Map.of(), minDur, maxDur);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (pOwner.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            pOwner.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return HalloweenVillagerAI.hasCandyOrApple(pOwner.getInventory());
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.start(pLevel, (LivingEntity)pEntity, pGameTime);
        this.cooldown = 20 * (3 + pLevel.random.nextInt(4)) + pLevel.random.nextInt(20);
        pEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        pEntity.getNavigation().stop();
        this.eatingTime = 80;
        SimpleContainer inventory = pEntity.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            if (!HalloweenVillagerAI.isCandyOrApple(itemstack)) continue;
            ItemStack s = itemstack.split(1);
            if (itemstack.getCount() == 0) {
                inventory.setItem(i, ItemStack.EMPTY);
            }
            pEntity.setItemInHand(InteractionHand.MAIN_HAND, s);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.eatingTime > 0 && HalloweenVillagerAI.isCandyOrApple(pEntity.getMainHandItem());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.eatingTime-- < 50) {
            ItemStack stack = pOwner.getMainHandItem();
            if (stack.isEmpty()) {
                return;
            }
            if (this.eatingTime % 2 == 0) {
                Vec3 pos = new Vec3(0.0, 0.0, 0.09);
                pos = pos.yRot(-pOwner.getYRot() * ((float)Math.PI / 180));
                pos = pos.add(pOwner.getX(), pOwner.getEyeY(), pOwner.getZ());
                pLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y - 0.2, pos.z, 2, 0.03, 0.05, 0.03, 0.0);
            }
            if (this.eatingTime % 5 == 0) {
                pOwner.playSound(pOwner.getEatingSound(stack), 0.3f + 0.4f * (float)pLevel.random.nextInt(2), (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.2f + 1.3f);
            }
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        ItemStack stack;
        Item item;
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        if (pEntity.isBaby() && this.eatingTime <= 0 && (item = (stack = pEntity.getMainHandItem()).getItem()) != Items.AIR) {
            pEntity.setAge(pEntity.getAge() - 6000);
            pEntity.heal(0.5f);
            item.finishUsingItem(stack, (Level)pLevel, (LivingEntity)pEntity);
        }
        pEntity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
    }
}

