/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.ingredientaction;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionHolder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionType;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;

public interface IngredientAction {
    public static final Codec<IngredientAction> CODEC = IngredientActionType.CODEC.dispatch("type", IngredientAction::getType, IngredientActionType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientAction> STREAM_CODEC = IngredientActionType.STREAM_CODEC.dispatch(IngredientAction::getType, IngredientActionType::streamCodec);

    public static ItemStack getRemaining(CraftingInput input, int index, List<IngredientActionHolder> ingredientActions) {
        ItemStack stack = input.getItem(index);
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IngredientActionHolder holder : ingredientActions) {
            if (!holder.filter().checkFilter(index, stack)) continue;
            return holder.action().transform(stack.copy(), index, input);
        }
        if (stack.hasCraftingRemainingItem()) {
            return stack.getCraftingRemainingItem();
        }
        return ItemStack.EMPTY;
    }

    public IngredientActionType<?> getType();

    public ItemStack transform(ItemStack var1, int var2, CraftingInput var3);
}

