/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.NeoForge;

public interface NativeEventWrapper {
    public static void onEvent(Context cx, Class<?> eventClass, Consumer<Event> consumer) {
        NativeEventWrapper.onEvent(cx, EventPriority.NORMAL, eventClass, consumer);
    }

    public static void onEvent(Context cx, EventPriority priority, Class<?> eventClass, Consumer<Event> consumer) {
        if (!Event.class.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("Event class must extend net.neoforged.bus.api.Event!");
        }
        ScriptType scriptType = ((KubeJSContext)cx).kjsFactory.manager.scriptType;
        Listeners.Key key = new Listeners.Key(eventClass, priority == null ? EventPriority.NORMAL : priority);
        Listeners listeners = scriptType.nativeEventListeners.get(key);
        if (listeners == null) {
            listeners = new Listeners(new LinkedList<Consumer<Event>>());
            scriptType.nativeEventListeners.put(key, listeners);
            IEventBus bus = IModBusEvent.class.isAssignableFrom(eventClass) ? KubeJS.modEventBus : NeoForge.EVENT_BUS;
            bus.addListener(priority, false, eventClass, (Consumer)listeners);
        }
        listeners.listeners.add(consumer);
    }

    @HideFromJS
    public record Listeners(Collection<Consumer<Event>> listeners) implements Consumer<Event>
    {
        @Override
        public void accept(Event event) {
            for (Consumer<Event> listener : this.listeners) {
                listener.accept(event);
            }
        }

        public record Key(Class<?> eventClass, EventPriority priority) {
            @Override
            public boolean equals(Object o) {
                boolean bl;
                block5: {
                    block3: {
                        block4: {
                            EventPriority aClass;
                            EventPriority eventPriority;
                            if (o == this) break block4;
                            if (!(o instanceof Key)) break block3;
                            Key key = (Key)o;
                            try {
                                aClass = eventPriority = key.eventClass();
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            EventPriority priority1 = eventPriority = key.priority();
                            if (aClass != this.eventClass || priority1 != this.priority) break block3;
                        }
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                return bl;
            }
        }
    }
}

