/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.misc.CommonHelper;

public final class TiabCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> COMMAND = (LiteralArgumentBuilder)Commands.literal((String)"tiab").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(stack -> TiabCommand.processTime((CommandSourceStack)stack.getSource(), EntityArgument.getPlayer((CommandContext)stack, (String)"player"), (Integer)stack.getArgument("seconds", Integer.class), true)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(stack -> TiabCommand.processTime((CommandSourceStack)stack.getSource(), EntityArgument.getPlayer((CommandContext)stack, (String)"player"), (Integer)stack.getArgument("seconds", Integer.class), false))))));

    public static int processTime(CommandSourceStack stack, ServerPlayer player, int time, boolean add) {
        ItemStack itemStack;
        if (time < 0) {
            return 0;
        }
        ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
        if (time > cfg.MAX_STORED_TIME() / cfg.TICKS_CONST()) {
            time = cfg.MAX_STORED_TIME() / cfg.TICKS_CONST();
        }
        if ((itemStack = ICommonTimeInABottleAPI.COMMON_API.get().findTiabItem((Player)player)).isEmpty()) {
            CommonHelper.sendStatusMessage(player, "No Time in a bottle item in inventory");
            stack.sendFailure((Component)Component.literal((String)"No Time in a bottle item in inventory!"));
            return 0;
        }
        Item item = itemStack.getItem();
        if (item instanceof ITiabItem) {
            int timeToAdd;
            ITiabItem itemTiab = (ITiabItem)item;
            int currentStoredEnergy = itemTiab.getStoredComponent(itemStack).stored();
            int n = timeToAdd = add ? time : -Math.min(time, currentStoredEnergy / cfg.TICKS_CONST());
            if (CommonHelper.isPositive(currentStoredEnergy + timeToAdd * cfg.TICKS_CONST())) {
                CommonHelper.modify(itemStack, ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), new StoredTimeComponent(0, 0), old -> new StoredTimeComponent(currentStoredEnergy + timeToAdd * cfg.TICKS_CONST(), old.total()));
                CommonHelper.sendStatusMessage(player, String.format("%s %d seconds", add ? "Added" : "Removed", Math.abs(timeToAdd)));
            }
        }
        stack.sendSuccess(() -> Component.literal((String)"Time added to bottle!"), false);
        return 1;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(COMMAND);
    }

    TiabCommand() {
    }
}

