/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.item.colored;

import com.benbenlaw.core.block.colored.ColoredBlock;
import com.benbenlaw.core.block.colored.ColoredButton;
import com.benbenlaw.core.block.colored.ColoredDoor;
import com.benbenlaw.core.block.colored.ColoredDoublePlantBlock;
import com.benbenlaw.core.block.colored.ColoredFence;
import com.benbenlaw.core.block.colored.ColoredFenceGate;
import com.benbenlaw.core.block.colored.ColoredFlower;
import com.benbenlaw.core.block.colored.ColoredFlowerPot;
import com.benbenlaw.core.block.colored.ColoredGrassBlock;
import com.benbenlaw.core.block.colored.ColoredLeaves;
import com.benbenlaw.core.block.colored.ColoredLog;
import com.benbenlaw.core.block.colored.ColoredPressurePlate;
import com.benbenlaw.core.block.colored.ColoredSapling;
import com.benbenlaw.core.block.colored.ColoredSlab;
import com.benbenlaw.core.block.colored.ColoredSnowyDirtBlock;
import com.benbenlaw.core.block.colored.ColoredSpreadingSnowyDirtBlock;
import com.benbenlaw.core.block.colored.ColoredStairs;
import com.benbenlaw.core.block.colored.ColoredTallGrassBlock;
import com.benbenlaw.core.block.colored.ColoredTrapDoor;
import com.benbenlaw.core.block.colored.ColoredWall;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.item.CoreDataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class ColoredBlockItem
extends BlockItem {
    public ColoredBlockItem(Item.Properties properties) {
        super(Blocks.AIR, properties);
    }

    public ColoredBlockItem(ColoredBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredStairs block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredSlab block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredWall block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredPressurePlate block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredButton block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredFence block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredFenceGate block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredDoor block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredTrapDoor block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredLog block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredLeaves block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredFlowerPot block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredSapling block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredFlower block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredGrassBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredSnowyDirtBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredSpreadingSnowyDirtBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredTallGrassBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ColoredBlockItem(ColoredDoublePlantBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        if (stack.get(CoreDataComponents.COLOR) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor color = ColorMap.getDyeColor(colorString);
            MutableComponent colorComponent = Component.translatable((String)ColorMap.getTranslationKey(colorString));
            MutableComponent litComponent = Component.translatable((String)"color.bblcore.lit");
            StringBuilder nameBuilder = new StringBuilder(super.getName(stack).getString()).append(" - ").append(colorComponent.getString());
            if (Boolean.TRUE.equals(stack.get(CoreDataComponents.LIT))) {
                nameBuilder.append(" - ").append(litComponent.getString());
            }
            TextColor textColor = color != DyeColor.BLACK ? TextColor.fromRgb((int)ColorMap.getColorValue(color)) : TextColor.fromRgb((int)0x3C3C3C);
            return Component.literal((String)nameBuilder.toString()).withStyle(style -> style.withColor(textColor.getValue()));
        }
        return Component.literal((String)super.getName(stack).getString());
    }
}

