/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.CoreStartupConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="bblcore")
public class ReturnToPlayerSpawnEvent {
    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
    }

    @SubscribeEvent
    public static void onVoidDamage(LivingDamageEvent.Post event) {
        if (((Boolean)CoreStartupConfig.enabledVoidProtection.get()).booleanValue()) {
            LivingEntity livingEntity = event.getEntity();
            DamageSource damageSource = event.getSource();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (damageSource.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                    BlockPos spawnPos = player.getRespawnPosition();
                    ResourceKey dimension = player.getRespawnDimension();
                    ServerLevel serverLevel = Objects.requireNonNull(player.getServer()).getLevel(dimension);
                    assert (serverLevel != null);
                    if (spawnPos == null) {
                        spawnPos = serverLevel.getSharedSpawnPos();
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.falling.default"));
                    }
                    player.fallDistance = 0.0f;
                    player.teleportTo(serverLevel, (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ(), 0.0f, 0.0f);
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.falling.home"));
                }
            }
        }
    }
}

