/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored;

import com.benbenlaw.core.block.colored.ColoredFlower;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredFlowerPot
extends FlowerPotBlock
implements IColored {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ColoredFlowerPot(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> flower, BlockBehaviour.Properties properties) {
        super(emptyPot, flower, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOR, (Comparable)DyeColor.WHITE)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, LIT});
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hitResult) {
        ItemStack itemstack = new ItemStack((ItemLike)this.getPotted());
        DyeColor color = (DyeColor)blockState.getValue(COLOR);
        itemstack.set(CoreDataComponents.COLOR, (Object)color.toString());
        itemstack.set(CoreDataComponents.LIT, (Object)((Boolean)blockState.getValue((Property)LIT)));
        player.addItem(itemstack);
        level.setBlock(blockPos, this.getEmptyPot().defaultBlockState(), 3);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public int getColor(int index) {
        DyeColor color = DyeColor.values()[index % DyeColor.values().length];
        return ColorMap.getColorValue(color);
    }

    @Override
    public int getColor(int index, ItemStack stack) {
        return this.getColor(index);
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        DyeColor color = (DyeColor)state.getValue(COLOR);
        for (ItemStack drop : drops) {
            if (drop.getItem() instanceof BlockItem && ((BlockItem)drop.getItem()).getBlock() == this) {
                drop.set(CoreDataComponents.COLOR, (Object)color.toString());
                drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            }
            if (!(Block.byItem((Item)drop.getItem()) instanceof ColoredFlower)) continue;
            drop.set(CoreDataComponents.COLOR, (Object)color.toString());
            drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getBlock() instanceof ColoredFlowerPot) {
            DyeColor color = (DyeColor)state.getValue(COLOR);
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(CoreDataComponents.COLOR, (Object)color.toString());
            stack.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.get(CoreDataComponents.COLOR) != null && stack.get(CoreDataComponents.LIT) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor dyeColor = ColorMap.getDyeColor(colorString);
            Boolean lit = (Boolean)stack.get(CoreDataComponents.LIT);
            assert (lit != null);
            BlockState newState = (BlockState)((BlockState)state.setValue(COLOR, (Comparable)dyeColor)).setValue((Property)LIT, (Comparable)lit);
            level.setBlockAndUpdate(pos, newState);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
    }
}

