/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class TankBlockEntity
extends SyncableBlockEntity {
    public final FluidTank FLUID_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            TankBlockEntity.this.setChanged();
            TankBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return TankBlockEntity.this.FLUID_TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return TankBlockEntity.this.FLUID_TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return TankBlockEntity.this.FLUID_TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == TankBlockEntity.this.FLUID_TANK.getFluid().getFluid() || TankBlockEntity.this.FLUID_TANK.isEmpty()) {
                return TankBlockEntity.this.FLUID_TANK.fill(resource, action);
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            assert (TankBlockEntity.this.level != null);
            if (resource.getFluid() == TankBlockEntity.this.FLUID_TANK.getFluid().getFluid()) {
                return TankBlockEntity.this.FLUID_TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (TankBlockEntity.this.FLUID_TANK.getFluidAmount() > 0) {
                return TankBlockEntity.this.FLUID_TANK.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };

    public TankBlockEntity(BlockPos pos, BlockState state) {
        super(null, pos, state);
    }

    public IFluidHandler getFluidHandlerCapability() {
        return this.fluidHandler;
    }

    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("tank_content", (Tag)this.FLUID_TANK.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.FLUID_TANK.readFromNBT(provider, compoundTag.getCompound("tank_content"));
        super.loadAdditional(compoundTag, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.FLUID_TANK);
    }

    public void tick() {
        this.sync();
    }
}

