/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.slot;

import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.slot.HasToggleableSlots;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleableSlotSyncPacket(BlockPos pos, int slot, boolean disabled) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleableSlotSyncPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("toggleable_slot_sync"));
    public static final StreamCodec<ByteBuf, ToggleableSlotSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ToggleableSlotSyncPacket::pos, (StreamCodec)ByteBufCodecs.INT, ToggleableSlotSyncPacket::slot, (StreamCodec)ByteBufCodecs.BOOL, ToggleableSlotSyncPacket::disabled, ToggleableSlotSyncPacket::new);

    public void handle(IPayloadContext context) {
        Level level = context.player().level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof HasToggleableSlots) {
            HasToggleableSlots slots = (HasToggleableSlots)blockEntity;
            slots.setSlotDisabled(this.slot, this.disabled);
            blockEntity.setChanged();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

