/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.lectern;

import com.github.minecraftschurlimods.bibliocraft.content.bigbook.BigBookContent;
import com.github.minecraftschurlimods.bibliocraft.content.bigbook.WrittenBigBookContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.OpenBookInLecternPacket;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class LecternUtil {
    public static boolean handleLecternUse(Level level, BlockPos pos, BlockState state, LecternBlockEntity lectern, Player player, InteractionHand hand) {
        ItemStack book = lectern.getBook();
        if (book.isEmpty()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.is(ItemTags.LECTERN_BOOKS)) {
                return false;
            }
            if (!(stack.has(BCDataComponents.BIG_BOOK_CONTENT) || stack.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT) || stack.has(BCDataComponents.STOCKROOM_CATALOG_CONTENT))) {
                return false;
            }
            lectern.setBook(stack.consumeAndReturn(1, (LivingEntity)player));
            LecternBlock.resetBookState((Entity)player, (Level)level, (BlockPos)pos, (BlockState)state, (boolean)true);
            level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (stack.has(BCDataComponents.BIG_BOOK_CONTENT)) {
                lectern.pageCount = ((BigBookContent)stack.get(BCDataComponents.BIG_BOOK_CONTENT)).pages().size();
            } else if (stack.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT)) {
                lectern.pageCount = ((WrittenBigBookContent)stack.get(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT)).pages().size();
            } else if (stack.has(BCDataComponents.STOCKROOM_CATALOG_CONTENT)) {
                lectern.pageCount = 1;
            }
            return true;
        }
        if (book.has(BCDataComponents.BIG_BOOK_CONTENT) || book.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT) || book.has(BCDataComponents.STOCKROOM_CATALOG_CONTENT)) {
            if (player.isSecondaryUseActive()) {
                LecternUtil.takeLecternBook(player, level, pos);
            } else if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new OpenBookInLecternPacket(pos, book), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return false;
    }

    public static void takeLecternBook(Player player, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return;
        }
        LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
        ItemStack stack = lectern.getBook();
        lectern.setBook(ItemStack.EMPTY);
        LecternBlock.resetBookState((Entity)player, (Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), (boolean)false);
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
        }
    }

    public static void tryGetLecternAndRun(Level level, BlockPos pos, Consumer<LecternBlockEntity> consumer) {
        if (!level.getBlockState(pos).hasProperty((Property)LecternBlock.HAS_BOOK) || !((Boolean)level.getBlockState(pos).getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return;
        }
        LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
        consumer.accept(lectern);
    }

    @Nullable
    public static <T> T tryGetLecternAndApply(Level level, BlockPos pos, Function<LecternBlockEntity, T> function) {
        if (!level.getBlockState(pos).hasProperty((Property)LecternBlock.HAS_BOOK) || !((Boolean)level.getBlockState(pos).getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return null;
        }
        LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
        return function.apply(lectern);
    }

    public static void openScreenForLectern(ItemStack stack, Player player, BlockPos pos) {
        if (stack.has(BCDataComponents.BIG_BOOK_CONTENT) || stack.has(BCDataComponents.WRITTEN_BIG_BOOK_CONTENT)) {
            ClientUtil.openBigBookScreen(stack, player, pos);
        } else if (stack.has(BCDataComponents.STOCKROOM_CATALOG_CONTENT)) {
            ClientUtil.openStockroomCatalogScreen(stack, player, pos);
        }
    }
}

