/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util;

import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.StringRepresentableEnum;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public record FormattedLine(String text, Style style, int size, Mode mode, Alignment alignment) {
    public static final int MIN_SIZE = 5;
    public static final int MAX_SIZE = 35;
    public static final Codec<FormattedLine> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("text").forGetter(FormattedLine::text), (App)Style.Serializer.CODEC.fieldOf("style").forGetter(FormattedLine::style), (App)ExtraCodecs.intRange((int)5, (int)35).fieldOf("size").forGetter(FormattedLine::size), (App)Mode.CODEC.fieldOf("mode").forGetter(FormattedLine::mode), (App)Alignment.CODEC.fieldOf("alignment").forGetter(FormattedLine::alignment)).apply((Applicative)inst, FormattedLine::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FormattedLine> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, FormattedLine::text, (StreamCodec)Style.Serializer.TRUSTED_STREAM_CODEC, FormattedLine::style, (StreamCodec)ByteBufCodecs.INT, FormattedLine::size, Mode.STREAM_CODEC, FormattedLine::mode, Alignment.STREAM_CODEC, FormattedLine::alignment, FormattedLine::new);
    public static final FormattedLine DEFAULT = new FormattedLine("", Style.EMPTY, 10, Mode.NORMAL, Alignment.LEFT);

    public FormattedLine withText(String text) {
        return new FormattedLine(text, this.style, this.size, this.mode, this.alignment);
    }

    public FormattedLine withStyle(Style style) {
        return new FormattedLine(this.text, style, this.size, this.mode, this.alignment);
    }

    public FormattedLine withSize(int size) {
        return new FormattedLine(this.text, this.style, size, this.mode, this.alignment);
    }

    public FormattedLine withMode(Mode mode) {
        return new FormattedLine(this.text, this.style, this.size, mode, this.alignment);
    }

    public FormattedLine withAlignment(Alignment alignment) {
        return new FormattedLine(this.text, this.style, this.size, this.mode, alignment);
    }

    public static enum Mode implements StringRepresentableEnum
    {
        NORMAL,
        SHADOW,
        GLOWING;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;

        public String getTranslationKey() {
            return "gui.bibliocraft.formatted_line.mode." + this.getSerializedName();
        }

        static {
            CODEC = CodecUtil.enumCodec(Mode::values);
            STREAM_CODEC = CodecUtil.enumStreamCodec(Mode::values, Enum::ordinal);
        }
    }

    public static enum Alignment implements StringRepresentableEnum
    {
        LEFT,
        CENTER,
        RIGHT;

        public static final Codec<Alignment> CODEC;
        public static final StreamCodec<ByteBuf, Alignment> STREAM_CODEC;

        public String getTranslationKey() {
            return "gui.bibliocraft.formatted_line.alignment." + this.getSerializedName();
        }

        static {
            CODEC = CodecUtil.enumCodec(Alignment::values);
            STREAM_CODEC = CodecUtil.enumStreamCodec(Alignment::values, Enum::ordinal);
        }
    }
}

