/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.typewriter;

import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterPage;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TypewriterPageCloningRecipe
extends CustomRecipe {
    public TypewriterPageCloningRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        int paper = 0;
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack written = input.getItem(i);
            if (written.isEmpty()) continue;
            if (written.is(BCItems.TYPEWRITER_PAGE)) {
                if (!stack.isEmpty()) {
                    return false;
                }
                stack = written;
                continue;
            }
            if (written.is(BCTags.Items.TYPEWRITER_PAPER)) {
                ++paper;
                continue;
            }
            return false;
        }
        return !stack.isEmpty() && paper > 0;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int paper = 0;
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack written = input.getItem(i);
            if (written.isEmpty()) continue;
            if (written.is(BCItems.TYPEWRITER_PAGE)) {
                if (!stack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                stack = written;
                continue;
            }
            if (written.is(BCTags.Items.TYPEWRITER_PAPER)) {
                ++paper;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (!stack.has(BCDataComponents.TYPEWRITER_PAGE)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copyWithCount(paper);
        result.set(BCDataComponents.TYPEWRITER_PAGE, (Object)((TypewriterPage)stack.get(BCDataComponents.TYPEWRITER_PAGE)));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList list = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.hasCraftingRemainingItem()) {
                list.set(i, (Object)stack.getCraftingRemainingItem());
                continue;
            }
            if (!stack.is(BCItems.TYPEWRITER_PAGE)) continue;
            list.set(i, (Object)stack.copyWithCount(1));
        }
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return BCRecipes.TYPEWRITER_PAGE_CLONING.get();
    }
}

