/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clock;

import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.content.clock.AbstractClockBlock;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallFancyClockBlock
extends AbstractClockBlock {
    private static final VoxelShape NORTH_SHAPE = ShapeUtil.combine(Shapes.box((double)0.25, (double)0.0625, (double)0.625, (double)0.75, (double)0.875, (double)1.0), Shapes.box((double)0.25, (double)0.875, (double)0.625, (double)0.3125, (double)0.9375, (double)0.6875), Shapes.box((double)0.4375, (double)0.875, (double)0.625, (double)0.5625, (double)0.9375, (double)0.6875), Shapes.box((double)0.6875, (double)0.875, (double)0.625, (double)0.75, (double)0.9375, (double)0.6875), Shapes.box((double)0.25, (double)0.875, (double)0.9375, (double)0.3125, (double)0.9375, (double)1.0), Shapes.box((double)0.4375, (double)0.875, (double)0.9375, (double)0.5625, (double)0.9375, (double)1.0), Shapes.box((double)0.6875, (double)0.875, (double)0.9375, (double)0.75, (double)0.9375, (double)1.0));
    private static final VoxelShape EAST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_SHAPE = ShapeUtil.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    private final BibliocraftWoodType woodType;

    public WallFancyClockBlock(BlockBehaviour.Properties properties) {
        this(properties, null);
    }

    public WallFancyClockBlock(BlockBehaviour.Properties properties, @Nullable BibliocraftWoodType woodType) {
        super(properties);
        this.woodType = woodType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.woodType != null ? new ItemStack((ItemLike)BCItems.FANCY_CLOCK.get(this.woodType)) : super.getCloneItemStack(state, target, level, pos, player);
    }
}

