/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clipboard;

import com.github.minecraftschurlimods.bibliocraft.content.clipboard.CheckboxState;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ClipboardContent(String title, int active, List<Page> pages) {
    public static final int MAX_PAGES = 50;
    public static final int MAX_LINES = 9;
    public static final ClipboardContent DEFAULT = new ClipboardContent("", 0, List.of(Page.DEFAULT));
    public static final Codec<ClipboardContent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("title").forGetter(ClipboardContent::title), (App)Codec.INT.fieldOf("active").forGetter(ClipboardContent::active), (App)Page.CODEC.listOf().fieldOf("pages").forGetter(ClipboardContent::pages)).apply((Applicative)inst, ClipboardContent::new));
    public static final StreamCodec<FriendlyByteBuf, ClipboardContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ClipboardContent::title, (StreamCodec)ByteBufCodecs.INT, ClipboardContent::active, (StreamCodec)Page.STREAM_CODEC.apply(ByteBufCodecs.list()), ClipboardContent::pages, ClipboardContent::new);

    public ClipboardContent setTitle(String title) {
        return new ClipboardContent(title, this.active, new ArrayList<Page>(this.pages));
    }

    public ClipboardContent setActive(int active) {
        return new ClipboardContent(this.title, active, new ArrayList<Page>(this.pages));
    }

    public boolean canHaveNewPage() {
        return this.active < this.pages.size() - 1 || this.pages.size() - 1 < 50;
    }

    public ClipboardContent nextPage() {
        if (this.active >= this.pages.size() - 1 && this.canHaveNewPage()) {
            ArrayList<Page> list = new ArrayList<Page>(this.pages);
            list.add(Page.DEFAULT);
            return this.setActive(list.size() - 1).setPages(list);
        }
        return this.active >= this.pages.size() - 1 ? this : this.setActive(this.active + 1);
    }

    public ClipboardContent prevPage() {
        return this.active == 0 ? this : this.setActive(this.active - 1);
    }

    public ClipboardContent setPages(List<Page> pages) {
        return new ClipboardContent(this.title, this.active, new ArrayList<Page>(pages));
    }

    public record Page(List<CheckboxState> checkboxes, List<String> lines) {
        public static final Page DEFAULT = new Page(new ArrayList<CheckboxState>(9), new ArrayList<String>(9));
        public static final Codec<Page> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CheckboxState.CODEC.listOf().fieldOf("checkboxes").forGetter(Page::checkboxes), (App)Codec.STRING.listOf().fieldOf("lines").forGetter(Page::lines)).apply((Applicative)inst, Page::new));
        public static final StreamCodec<FriendlyByteBuf, Page> STREAM_CODEC = StreamCodec.composite((StreamCodec)CheckboxState.STREAM_CODEC.apply(ByteBufCodecs.list()), Page::checkboxes, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), Page::lines, Page::new);

        public Page(List<CheckboxState> checkboxes, List<String> lines) {
            this.checkboxes = BCUtil.extend(checkboxes, 9, CheckboxState.EMPTY);
            this.lines = BCUtil.extend(lines, 9, "");
        }

        public Page setCheckboxes(List<CheckboxState> checkboxes) {
            return new Page(checkboxes, new ArrayList<String>(this.lines));
        }

        public Page setLines(List<String> lines) {
            return new Page(this.checkboxes, new ArrayList<String>(lines));
        }
    }
}

