/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.bigbook;

import com.github.minecraftschurlimods.bibliocraft.util.FormattedLine;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record WrittenBigBookContent(List<List<FormattedLine>> pages, String title, String author, int generation, int currentPage) {
    public static final Codec<WrittenBigBookContent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FormattedLine.CODEC.sizeLimitedListOf(256).listOf().fieldOf("pages").forGetter(WrittenBigBookContent::pages), (App)Codec.string((int)0, (int)32).fieldOf("title").forGetter(WrittenBigBookContent::title), (App)Codec.STRING.fieldOf("author").forGetter(WrittenBigBookContent::author), (App)ExtraCodecs.intRange((int)0, (int)3).optionalFieldOf("generation", (Object)0).forGetter(WrittenBigBookContent::generation), (App)ExtraCodecs.intRange((int)0, (int)255).optionalFieldOf("current_page", (Object)0).forGetter(WrittenBigBookContent::currentPage)).apply((Applicative)inst, WrittenBigBookContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrittenBigBookContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)FormattedLine.STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list()), WrittenBigBookContent::pages, (StreamCodec)ByteBufCodecs.stringUtf8((int)32), WrittenBigBookContent::title, (StreamCodec)ByteBufCodecs.STRING_UTF8, WrittenBigBookContent::author, (StreamCodec)ByteBufCodecs.VAR_INT, WrittenBigBookContent::generation, (StreamCodec)ByteBufCodecs.VAR_INT, WrittenBigBookContent::currentPage, WrittenBigBookContent::new);
    public static final WrittenBigBookContent DEFAULT = new WrittenBigBookContent(List.of(), "", "", 0, 0);

    @Nullable
    public WrittenBigBookContent tryCraftCopy() {
        return this.generation >= 2 ? null : new WrittenBigBookContent(new ArrayList<List<FormattedLine>>(this.pages), this.title, this.author, this.generation + 1, this.currentPage);
    }
}

